/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.jcr;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Calendar;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.jackrabbit.value.BinaryValue;
import org.apache.sling.testing.mock.jcr.AbstractItem;
import org.apache.sling.testing.mock.jcr.ItemData;

class MockProperty
extends AbstractItem
implements Property {
    public MockProperty(ItemData itemData, Session session) {
        super(itemData, session);
        if (this.itemData.getValues() == null) {
            try {
                this.itemData.setValues(new Value[]{this.getSession().getValueFactory().createValue("")});
            }
            catch (RepositoryException ex) {
                throw new RuntimeException("Initializing property failed.", ex);
            }
        }
    }

    private Value internalGetValue() throws RepositoryException {
        if (this.itemData.getValues().length > 1) {
            throw new ValueFormatException(this + " is a multi-valued property, so it's values can only be retrieved as an array");
        }
        return this.itemData.getValues()[0];
    }

    public Value getValue() throws RepositoryException {
        return this.internalGetValue();
    }

    public Value[] getValues() throws RepositoryException {
        Value[] valuesCopy = new Value[this.itemData.getValues().length];
        for (int i = 0; i < this.itemData.getValues().length; ++i) {
            valuesCopy[i] = this.itemData.getValues()[i];
        }
        return valuesCopy;
    }

    public void setValue(Value newValue) throws RepositoryException {
        this.itemData.setValues(new Value[]{newValue});
        this.itemData.setMultiple(false);
    }

    public void setValue(Value[] newValues) throws RepositoryException {
        Value[] values = new Value[newValues.length];
        for (int i = 0; i < newValues.length; ++i) {
            values[i] = newValues[i];
        }
        this.itemData.setValues(values);
        this.itemData.setMultiple(true);
    }

    public void setValue(String newValue) throws RepositoryException {
        this.itemData.setValues(new Value[]{this.getSession().getValueFactory().createValue(newValue)});
        this.itemData.setMultiple(false);
    }

    public void setValue(String[] newValues) throws RepositoryException {
        Value[] values = new Value[newValues.length];
        for (int i = 0; i < newValues.length; ++i) {
            values[i] = this.getSession().getValueFactory().createValue(newValues[i]);
        }
        this.itemData.setValues(values);
        this.itemData.setMultiple(true);
    }

    public void setValue(InputStream newValue) throws RepositoryException {
        this.itemData.setValues(new Value[]{new BinaryValue(newValue)});
        this.itemData.setMultiple(false);
    }

    public void setValue(long newValue) throws RepositoryException {
        this.itemData.setValues(new Value[]{this.getSession().getValueFactory().createValue(newValue)});
        this.itemData.setMultiple(false);
    }

    public void setValue(double newValue) throws RepositoryException {
        this.itemData.setValues(new Value[]{this.getSession().getValueFactory().createValue(newValue)});
        this.itemData.setMultiple(false);
    }

    public void setValue(Calendar newValue) throws RepositoryException {
        this.itemData.setValues(new Value[]{this.getSession().getValueFactory().createValue(newValue)});
        this.itemData.setMultiple(false);
    }

    public void setValue(boolean newValue) throws RepositoryException {
        this.itemData.setValues(new Value[]{this.getSession().getValueFactory().createValue(newValue)});
        this.itemData.setMultiple(false);
    }

    public void setValue(Node newValue) throws RepositoryException {
        this.itemData.setValues(new Value[]{this.getSession().getValueFactory().createValue(newValue)});
        this.itemData.setMultiple(false);
    }

    public void setValue(Binary newValue) throws RepositoryException {
        this.itemData.setValues(new Value[]{new BinaryValue(newValue)});
        this.itemData.setMultiple(false);
    }

    public void setValue(BigDecimal newValue) throws RepositoryException {
        this.itemData.setValues(new Value[]{this.getSession().getValueFactory().createValue(newValue)});
        this.itemData.setMultiple(false);
    }

    public boolean getBoolean() throws RepositoryException {
        return this.internalGetValue().getBoolean();
    }

    public Calendar getDate() throws RepositoryException {
        return this.internalGetValue().getDate();
    }

    public double getDouble() throws RepositoryException {
        return this.internalGetValue().getDouble();
    }

    public long getLong() throws RepositoryException {
        return this.internalGetValue().getLong();
    }

    public String getString() throws RepositoryException {
        return this.internalGetValue().getString();
    }

    public InputStream getStream() throws RepositoryException {
        return this.internalGetValue().getStream();
    }

    public Binary getBinary() throws RepositoryException {
        return this.internalGetValue().getBinary();
    }

    public BigDecimal getDecimal() throws RepositoryException {
        return this.internalGetValue().getDecimal();
    }

    public int getType() throws RepositoryException {
        return this.itemData.getValues()[0].getType();
    }

    public long getLength() throws RepositoryException {
        return this.getValue().getString().length();
    }

    public long[] getLengths() throws RepositoryException {
        long[] lengths = new long[this.itemData.getValues().length];
        for (int i = 0; i < this.itemData.getValues().length; ++i) {
            lengths[i] = this.itemData.getValues()[i].getString().length();
        }
        return lengths;
    }

    public boolean isNode() {
        return false;
    }

    public boolean isMultiple() throws RepositoryException {
        return this.itemData.isMultiple();
    }

    public PropertyDefinition getDefinition() throws RepositoryException {
        return new MockPropertyDefinition();
    }

    public int hashCode() {
        return this.itemData.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof MockProperty) {
            return this.itemData.equals(((MockProperty)obj).itemData);
        }
        return false;
    }

    public Node getNode() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public Property getProperty() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    private final class MockPropertyDefinition
    implements PropertyDefinition {
        private MockPropertyDefinition() {
        }

        public boolean isMultiple() {
            return MockProperty.this.itemData.isMultiple();
        }

        public Value[] getDefaultValues() {
            throw new UnsupportedOperationException();
        }

        public int getRequiredType() {
            throw new UnsupportedOperationException();
        }

        public String[] getValueConstraints() {
            throw new UnsupportedOperationException();
        }

        public NodeType getDeclaringNodeType() {
            throw new UnsupportedOperationException();
        }

        public String getName() {
            throw new UnsupportedOperationException();
        }

        public int getOnParentVersion() {
            throw new UnsupportedOperationException();
        }

        public boolean isAutoCreated() {
            throw new UnsupportedOperationException();
        }

        public boolean isMandatory() {
            throw new UnsupportedOperationException();
        }

        public boolean isProtected() {
            throw new UnsupportedOperationException();
        }

        public String[] getAvailableQueryOperators() {
            throw new UnsupportedOperationException();
        }

        public boolean isFullTextSearchable() {
            throw new UnsupportedOperationException();
        }

        public boolean isQueryOrderable() {
            throw new UnsupportedOperationException();
        }
    }
}

