/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.apache.sling.testing.mock.osgi.MockServiceReference;
import org.apache.sling.testing.mock.osgi.OsgiMetadataUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.w3c.dom.Document;

class MockServiceRegistration
implements ServiceRegistration {
    private static volatile long serviceCounter;
    private final Set<String> clazzes;
    private final Object service;
    private Dictionary<String, Object> properties;
    private final ServiceReference serviceReference;

    public MockServiceRegistration(Bundle bundle, String[] clazzes, Object service, Dictionary<String, Object> properties) {
        this.clazzes = new HashSet<String>((Collection<String>)ImmutableList.copyOf((Object[])clazzes));
        this.service = service;
        this.properties = properties != null ? properties : new Hashtable();
        this.properties.put("service.id", ++serviceCounter);
        this.serviceReference = new MockServiceReference(bundle, this);
        this.readOsgiMetadata();
    }

    public ServiceReference getReference() {
        return this.serviceReference;
    }

    public void setProperties(Dictionary properties) {
        this.properties = properties;
    }

    public void unregister() {
    }

    Dictionary<String, Object> getProperties() {
        return this.properties;
    }

    boolean matches(String clazz, String filter) {
        return this.clazzes.contains(clazz);
    }

    Object getService() {
        return this.service;
    }

    private void readOsgiMetadata() {
        Class<?> serviceClass = this.service.getClass();
        Document doc = OsgiMetadataUtil.getMetadata(serviceClass);
        if (doc == null) {
            return;
        }
        this.clazzes.addAll(OsgiMetadataUtil.getServiceInterfaces(serviceClass, doc));
        Map<String, Object> props = OsgiMetadataUtil.getProperties(serviceClass, doc);
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            this.properties.put(entry.getKey(), entry.getValue());
        }
    }
}

