/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.sling.testing.mock.osgi.MapUtil;
import org.apache.sling.testing.mock.osgi.NoScrMetadataException;
import org.apache.sling.testing.mock.osgi.OsgiMetadataUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.w3c.dom.Document;

final class ReflectionServiceUtil {
    private ReflectionServiceUtil() {
    }

    public static boolean activateDeactivate(Object target, ComponentContext componentContext, boolean activate) {
        Class[] classArray;
        Class<?> targetClass = target.getClass();
        Document metadata = OsgiMetadataUtil.getMetadata(targetClass);
        if (metadata == null) {
            throw new NoScrMetadataException(targetClass);
        }
        String methodName = activate ? OsgiMetadataUtil.getActivateMethodName(targetClass, metadata) : OsgiMetadataUtil.getDeactivateMethodName(targetClass, metadata);
        if (StringUtils.isEmpty((CharSequence)methodName)) {
            return false;
        }
        Method method = ReflectionServiceUtil.getMethod(targetClass, methodName, new Class[]{ComponentContext.class});
        if (method != null) {
            ReflectionServiceUtil.invokeMethod(target, method, new Object[]{componentContext});
            return true;
        }
        method = ReflectionServiceUtil.getMethod(targetClass, methodName, new Class[]{BundleContext.class});
        if (method != null) {
            ReflectionServiceUtil.invokeMethod(target, method, new Object[]{componentContext.getBundleContext()});
            return true;
        }
        method = ReflectionServiceUtil.getMethod(targetClass, methodName, new Class[]{Map.class});
        if (method != null) {
            ReflectionServiceUtil.invokeMethod(target, method, new Object[]{MapUtil.toMap(componentContext.getProperties())});
            return true;
        }
        if (!activate && (method = ReflectionServiceUtil.getMethod(targetClass, methodName, new Class[]{Integer.TYPE})) != null) {
            ReflectionServiceUtil.invokeMethod(target, method, new Object[]{0});
            return true;
        }
        if (!activate && (method = ReflectionServiceUtil.getMethod(targetClass, methodName, new Class[]{Integer.class})) != null) {
            ReflectionServiceUtil.invokeMethod(target, method, new Object[]{0});
            return true;
        }
        if (activate) {
            Class[] classArray2 = new Class[3];
            classArray2[0] = ComponentContext.class;
            classArray2[1] = BundleContext.class;
            classArray = classArray2;
            classArray2[2] = Map.class;
        } else {
            Class[] classArray3 = new Class[5];
            classArray3[0] = ComponentContext.class;
            classArray3[1] = BundleContext.class;
            classArray3[2] = Map.class;
            classArray3[3] = Integer.TYPE;
            classArray = classArray3;
            classArray3[4] = Integer.class;
        }
        Class[] mixedArgsAllowed = classArray;
        method = ReflectionServiceUtil.getMethodWithAnyCombinationArgs(targetClass, methodName, mixedArgsAllowed);
        if (method != null) {
            Object[] args = new Object[method.getParameterTypes().length];
            for (int i = 0; i < args.length; ++i) {
                if (method.getParameterTypes()[i] == ComponentContext.class) {
                    args[i] = componentContext;
                    continue;
                }
                if (method.getParameterTypes()[i] == BundleContext.class) {
                    args[i] = componentContext.getBundleContext();
                    continue;
                }
                if (method.getParameterTypes()[i] == Map.class) {
                    args[i] = MapUtil.toMap(componentContext.getProperties());
                    continue;
                }
                if (method.getParameterTypes()[i] != Integer.TYPE && method.getParameterTypes()[i] != Integer.class) continue;
                args[i] = 0;
            }
            ReflectionServiceUtil.invokeMethod(target, method, args);
            return true;
        }
        method = ReflectionServiceUtil.getMethod(targetClass, methodName, new Class[0]);
        if (method != null) {
            ReflectionServiceUtil.invokeMethod(target, method, new Object[0]);
            return true;
        }
        throw new RuntimeException("No matching " + (activate ? "activation" : "deactivation") + " method with name '" + methodName + "' " + " found in class " + targetClass.getName());
    }

    public static boolean modified(Object target, BundleContext bundleContext, Map<String, Object> properties) {
        Class<?> targetClass = target.getClass();
        Document metadata = OsgiMetadataUtil.getMetadata(targetClass);
        if (metadata == null) {
            throw new NoScrMetadataException(targetClass);
        }
        String methodName = OsgiMetadataUtil.getModifiedMethodName(targetClass, metadata);
        if (StringUtils.isEmpty((CharSequence)methodName)) {
            return false;
        }
        Method method = ReflectionServiceUtil.getMethod(targetClass, methodName, new Class[]{Map.class});
        if (method != null) {
            ReflectionServiceUtil.invokeMethod(target, method, new Object[]{properties});
            return true;
        }
        throw new RuntimeException("No matching modified method with name '" + methodName + "' " + " found in class " + targetClass.getName());
    }

    private static Method getMethod(Class clazz, String methodName, Class<?>[] types) {
        Method[] methods;
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (!StringUtils.equals((CharSequence)method.getName(), (CharSequence)methodName) || !Arrays.equals(method.getParameterTypes(), types)) continue;
            return method;
        }
        Class superClass = clazz.getSuperclass();
        if (superClass != null && superClass != Object.class) {
            return ReflectionServiceUtil.getMethod(superClass, methodName, types);
        }
        return null;
    }

    private static Method getMethodWithAssignableTypes(Class clazz, String methodName, Class<?>[] types) {
        Method[] methods;
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (!StringUtils.equals((CharSequence)method.getName(), (CharSequence)methodName) || method.getParameterTypes().length != types.length) continue;
            boolean foundMismatch = false;
            for (int i = 0; i < types.length; ++i) {
                if (method.getParameterTypes()[i].isAssignableFrom(types[i])) continue;
                foundMismatch = false;
                break;
            }
            if (foundMismatch) continue;
            return method;
        }
        Class superClass = clazz.getSuperclass();
        if (superClass != null && superClass != Object.class) {
            return ReflectionServiceUtil.getMethodWithAssignableTypes(superClass, methodName, types);
        }
        return null;
    }

    private static Method getMethodWithAnyCombinationArgs(Class clazz, String methodName, Class<?>[] types) {
        Method[] methods;
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (!StringUtils.equals((CharSequence)method.getName(), (CharSequence)methodName) || method.getParameterTypes().length <= 1) continue;
            for (Class<?> parameterType : method.getParameterTypes()) {
                if (ArrayUtils.contains((Object[])types, parameterType)) continue;
                return null;
            }
            return method;
        }
        Class superClass = clazz.getSuperclass();
        if (superClass != null && superClass != Object.class) {
            return ReflectionServiceUtil.getMethodWithAnyCombinationArgs(superClass, methodName, types);
        }
        return null;
    }

    private static void invokeMethod(Object target, Method method, Object[] args) {
        try {
            method.setAccessible(true);
            method.invoke(target, args);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("Unable to invoke activate/deactivate method for class " + target.getClass().getName(), ex);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException("Unable to invoke activate/deactivate method for class " + target.getClass().getName(), ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException("Unable to invoke activate/deactivate method for class " + target.getClass().getName(), ex.getCause());
        }
    }

    public static boolean injectServices(Object target, BundleContext bundleContext) {
        Class<?> targetClass = target.getClass();
        Document metadata = OsgiMetadataUtil.getMetadata(targetClass);
        if (metadata == null) {
            throw new NoScrMetadataException(targetClass);
        }
        List<OsgiMetadataUtil.Reference> references = OsgiMetadataUtil.getReferences(targetClass, metadata);
        if (references.isEmpty()) {
            return false;
        }
        for (OsgiMetadataUtil.Reference reference : references) {
            ReflectionServiceUtil.injectServiceReference(reference, target, bundleContext);
        }
        return true;
    }

    private static void injectServiceReference(OsgiMetadataUtil.Reference reference, Object target, BundleContext bundleContext) {
        Class<?> type;
        Class<?> targetClass = target.getClass();
        try {
            type = Class.forName(reference.getInterfaceType());
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("Unable to instantiate reference type: " + reference.getInterfaceType(), ex);
        }
        List<ServiceInfo> matchingServices = ReflectionServiceUtil.getMatchingServices(type, bundleContext);
        if (matchingServices.isEmpty()) {
            boolean isOptional;
            boolean bl = isOptional = reference.getCardinality() == ReferenceCardinality.OPTIONAL_UNARY || reference.getCardinality() == ReferenceCardinality.OPTIONAL_MULTIPLE;
            if (!isOptional) {
                throw new RuntimeException("Unable to inject mandatory reference '" + reference.getName() + "' for class " + targetClass.getName());
            }
        }
        if (matchingServices.size() > 1 && (reference.getCardinality() == ReferenceCardinality.MANDATORY_UNARY || reference.getCardinality() == ReferenceCardinality.OPTIONAL_UNARY)) {
            throw new RuntimeException("Multiple matches found for unary reference '" + reference.getName() + "' for class " + targetClass.getName());
        }
        String bindMethodName = reference.getBind();
        if (StringUtils.isNotEmpty((CharSequence)bindMethodName)) {
            Class<?> interfaceType;
            Method bindMethod = ReflectionServiceUtil.getMethod(targetClass, bindMethodName, new Class[]{ServiceReference.class});
            if (bindMethod != null) {
                for (ServiceInfo matchingService : matchingServices) {
                    ReflectionServiceUtil.invokeMethod(target, bindMethod, new Object[]{matchingService.getServiceReference()});
                }
                return;
            }
            try {
                interfaceType = Class.forName(reference.getInterfaceType());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Service reference type not found: " + reference.getInterfaceType());
            }
            bindMethod = ReflectionServiceUtil.getMethodWithAssignableTypes(targetClass, bindMethodName, new Class[]{interfaceType});
            if (bindMethod != null) {
                for (ServiceInfo matchingService : matchingServices) {
                    ReflectionServiceUtil.invokeMethod(target, bindMethod, new Object[]{matchingService.getServiceInstance()});
                }
                return;
            }
            bindMethod = ReflectionServiceUtil.getMethodWithAssignableTypes(targetClass, bindMethodName, new Class[]{interfaceType, Map.class});
            if (bindMethod != null) {
                for (ServiceInfo matchingService : matchingServices) {
                    ReflectionServiceUtil.invokeMethod(target, bindMethod, new Object[]{matchingService.getServiceInstance(), matchingService.getServiceConfig()});
                }
                return;
            }
        }
        throw new RuntimeException("Bind method with name " + bindMethodName + " not found " + "for reference '" + reference.getName() + "' for class {}" + targetClass.getName());
    }

    private static List<ServiceInfo> getMatchingServices(Class<?> type, BundleContext bundleContext) {
        ArrayList<ServiceInfo> matchingServices = new ArrayList<ServiceInfo>();
        try {
            ServiceReference[] references = bundleContext.getServiceReferences(type.getName(), null);
            if (references != null) {
                for (ServiceReference serviceReference : references) {
                    String[] keys;
                    Object serviceInstance = bundleContext.getService(serviceReference);
                    HashMap<String, Object> serviceConfig = new HashMap<String, Object>();
                    for (String key : keys = serviceReference.getPropertyKeys()) {
                        serviceConfig.put(key, serviceReference.getProperty(key));
                    }
                    matchingServices.add(new ServiceInfo(serviceInstance, serviceConfig, serviceReference));
                }
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        return matchingServices;
    }

    private static class ServiceInfo {
        private final Object serviceInstance;
        private final Map<String, Object> serviceConfig;
        private final ServiceReference serviceReference;

        public ServiceInfo(Object serviceInstance, Map<String, Object> serviceConfig, ServiceReference serviceReference) {
            this.serviceInstance = serviceInstance;
            this.serviceConfig = serviceConfig;
            this.serviceReference = serviceReference;
        }

        public Object getServiceInstance() {
            return this.serviceInstance;
        }

        public Map<String, Object> getServiceConfig() {
            return this.serviceConfig;
        }

        public ServiceReference getServiceReference() {
            return this.serviceReference;
        }
    }
}

