/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi.junit;

import org.apache.sling.testing.mock.osgi.context.OsgiContextImpl;
import org.apache.sling.testing.mock.osgi.junit.OsgiContextCallback;
import org.junit.rules.ExternalResource;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public final class OsgiContext
extends OsgiContextImpl
implements TestRule {
    private final OsgiContextCallback setUpCallback;
    private final OsgiContextCallback tearDownCallback;
    private final TestRule delegate;

    public OsgiContext() {
        this(null, null);
    }

    public OsgiContext(OsgiContextCallback setUpCallback) {
        this(setUpCallback, null);
    }

    public OsgiContext(OsgiContextCallback setUpCallback, OsgiContextCallback tearDownCallback) {
        this.setUpCallback = setUpCallback;
        this.tearDownCallback = tearDownCallback;
        this.delegate = new ExternalResource(){

            protected void before() {
                OsgiContext.this.setUp();
                OsgiContext.this.executeSetUpCallback();
            }

            protected void after() {
                OsgiContext.this.executeTearDownCallback();
                OsgiContext.this.tearDown();
            }
        };
    }

    public Statement apply(Statement base, Description description) {
        return this.delegate.apply(base, description);
    }

    private void executeSetUpCallback() {
        if (this.setUpCallback != null) {
            try {
                this.setUpCallback.execute(this);
            }
            catch (Throwable ex) {
                throw new RuntimeException("Executing setup callback failed.", ex);
            }
        }
    }

    private void executeTearDownCallback() {
        if (this.tearDownCallback != null) {
            try {
                this.tearDownCallback.execute(this);
            }
            catch (Throwable ex) {
                throw new RuntimeException("Executing setup callback failed.", ex);
            }
        }
    }
}

