/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi;

import java.util.Collections;
import java.util.Dictionary;
import org.apache.sling.testing.mock.osgi.MockServiceRegistration;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;

class MockServiceReference
implements ServiceReference {
    private final Bundle bundle;
    private final MockServiceRegistration serviceRegistration;

    public MockServiceReference(Bundle bundle, MockServiceRegistration serviceRegistration) {
        this.bundle = bundle;
        this.serviceRegistration = serviceRegistration;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public void setProperty(String key, Object value) {
        this.serviceRegistration.getProperties().put(key, value);
    }

    public Object getProperty(String key) {
        return this.serviceRegistration.getProperties().get(key);
    }

    public String[] getPropertyKeys() {
        Dictionary<String, Object> props = this.serviceRegistration.getProperties();
        return Collections.list(props.keys()).toArray(new String[props.size()]);
    }

    public int hashCode() {
        return Long.valueOf(this.getServiceId()).hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MockServiceReference)) {
            return false;
        }
        return Long.valueOf(this.getServiceId()).equals(((MockServiceReference)obj).getServiceId());
    }

    public int compareTo(Object obj) {
        if (!(obj instanceof MockServiceReference)) {
            return 0;
        }
        Integer serviceRanking = this.getServiceRanking();
        Integer otherServiceRanking = ((MockServiceReference)obj).getServiceRanking();
        int serviceRankingCompare = otherServiceRanking.compareTo(serviceRanking);
        if (serviceRankingCompare == 0) {
            Long serviceId = this.getServiceId();
            Long otherServiceId = ((MockServiceReference)obj).getServiceId();
            return serviceId.compareTo(otherServiceId);
        }
        return serviceRankingCompare;
    }

    long getServiceId() {
        Number serviceID = (Number)this.getProperty("service.id");
        if (serviceID != null) {
            return serviceID.longValue();
        }
        return 0L;
    }

    int getServiceRanking() {
        Number serviceRanking = (Number)this.getProperty("service.ranking");
        if (serviceRanking != null) {
            return serviceRanking.intValue();
        }
        return 0;
    }

    Object getService() {
        return this.serviceRegistration.getService();
    }

    public Bundle[] getUsingBundles() {
        throw new UnsupportedOperationException();
    }

    public boolean isAssignableTo(Bundle otherBundle, String className) {
        throw new UnsupportedOperationException();
    }
}

