/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.apache.sling.testing.mock.osgi.MockBundleContext;
import org.apache.sling.testing.mock.osgi.MockServiceReference;
import org.apache.sling.testing.mock.osgi.OsgiMetadataUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

class MockServiceRegistration
implements ServiceRegistration,
Comparable<MockServiceRegistration> {
    private static volatile long serviceCounter;
    private final Long serviceId = ++serviceCounter;
    private final Set<String> clazzes;
    private final Object service;
    private Dictionary<String, Object> properties;
    private final ServiceReference serviceReference;
    private final MockBundleContext bundleContext;

    public MockServiceRegistration(Bundle bundle, String[] clazzes, Object service, Dictionary<String, Object> properties, MockBundleContext bundleContext) {
        this.clazzes = new HashSet<String>((Collection<String>)ImmutableList.copyOf((Object[])clazzes));
        this.service = service;
        this.properties = properties != null ? properties : new Hashtable();
        this.properties.put("service.id", this.serviceId);
        this.serviceReference = new MockServiceReference(bundle, this);
        this.bundleContext = bundleContext;
        this.readOsgiMetadata();
    }

    public ServiceReference getReference() {
        return this.serviceReference;
    }

    public void setProperties(Dictionary properties) {
        this.properties = properties;
    }

    public void unregister() {
        this.bundleContext.unregisterService(this);
    }

    Dictionary<String, Object> getProperties() {
        return this.properties;
    }

    boolean matches(String clazz, String filter) {
        return this.clazzes.contains(clazz);
    }

    Set<String> getClasses() {
        return this.clazzes;
    }

    Object getService() {
        return this.service;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MockServiceRegistration)) {
            return false;
        }
        return this.serviceId.equals(((MockServiceRegistration)obj).serviceId);
    }

    public int hashCode() {
        return this.serviceId.hashCode();
    }

    @Override
    public int compareTo(MockServiceRegistration obj) {
        return this.serviceId.compareTo(obj.serviceId);
    }

    private void readOsgiMetadata() {
        Class<?> serviceClass = this.service.getClass();
        OsgiMetadataUtil.OsgiMetadata metadata = OsgiMetadataUtil.getMetadata(serviceClass);
        if (metadata == null) {
            return;
        }
        this.clazzes.addAll(metadata.getServiceInterfaces());
        Map<String, Object> props = metadata.getProperties();
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            this.properties.put(entry.getKey(), entry.getValue());
        }
    }
}

