/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.sling.testing.mock.osgi.MapUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

public final class MockBundle
implements Bundle {
    private static volatile long bundleCounter;
    private final long bundleId;
    private final BundleContext bundleContext;
    private Map<String, String> headers = ImmutableMap.of();
    private String symbolicName = "mock-bundle";
    private long lastModified;

    public MockBundle(BundleContext bundleContext) {
        this.bundleId = ++bundleCounter;
        this.bundleContext = bundleContext;
    }

    public long getBundleId() {
        return this.bundleId;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public URL getEntry(String name) {
        String nameToQuery = name.startsWith("/") ? name : "/" + name;
        return this.getClass().getResource(nameToQuery);
    }

    public int getState() {
        return 32;
    }

    public Dictionary<String, String> getHeaders() {
        return MapUtil.toDictionary(this.headers);
    }

    public Dictionary<String, String> getHeaders(String locale) {
        return this.getHeaders();
    }

    public void setHeaders(Map<String, String> value) {
        this.headers = value;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public void setSymbolicName(String value) {
        this.symbolicName = value;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public Enumeration<String> getEntryPaths(String path) {
        String queryPath = path.startsWith("/") ? path : "/" + path;
        URL res = this.getClass().getResource(queryPath);
        if (res == null) {
            return null;
        }
        Vector<String> matching = new Vector<String>();
        try {
            File file = new File(res.toURI());
            if (file.isDirectory()) {
                for (File entry : file.listFiles()) {
                    String name = entry.isDirectory() ? entry.getName() + "/" : entry.getName();
                    matching.add(this.relativeWithTrailingSlash(queryPath.substring(1, queryPath.length())) + name);
                }
            }
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Failed opening file from " + res, e);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Failed opening file from " + res, e);
        }
        if (matching.isEmpty()) {
            return null;
        }
        return matching.elements();
    }

    private String relativeWithTrailingSlash(String queryPath) {
        if (queryPath.startsWith("/")) {
            queryPath = queryPath.substring(1, queryPath.length());
        }
        if (!queryPath.isEmpty() && !queryPath.endsWith("/")) {
            queryPath = queryPath + "/";
        }
        return queryPath;
    }

    public Enumeration<URL> findEntries(String path, String filePattern, boolean recurse) {
        throw new UnsupportedOperationException();
    }

    public String getLocation() {
        throw new UnsupportedOperationException();
    }

    public ServiceReference[] getRegisteredServices() {
        throw new UnsupportedOperationException();
    }

    public URL getResource(String name) {
        throw new UnsupportedOperationException();
    }

    public Enumeration<URL> getResources(String name) {
        throw new UnsupportedOperationException();
    }

    public ServiceReference[] getServicesInUse() {
        throw new UnsupportedOperationException();
    }

    public boolean hasPermission(Object permission) {
        throw new UnsupportedOperationException();
    }

    public Class<?> loadClass(String name) {
        throw new UnsupportedOperationException();
    }

    public void start() {
        throw new UnsupportedOperationException();
    }

    public void stop() {
        throw new UnsupportedOperationException();
    }

    public void uninstall() {
        throw new UnsupportedOperationException();
    }

    public void update() {
        throw new UnsupportedOperationException();
    }

    public void update(InputStream inputStream) {
        throw new UnsupportedOperationException();
    }

    public void start(int options) {
        throw new UnsupportedOperationException();
    }

    public void stop(int options) {
        throw new UnsupportedOperationException();
    }

    public Map<X509Certificate, List<X509Certificate>> getSignerCertificates(int signersType) {
        throw new UnsupportedOperationException();
    }

    public Version getVersion() {
        throw new UnsupportedOperationException();
    }

    public int compareTo(Bundle o) {
        throw new UnsupportedOperationException();
    }

    public <A> A adapt(Class<A> type) {
        throw new UnsupportedOperationException();
    }

    public File getDataFile(String filename) {
        throw new UnsupportedOperationException();
    }
}

