/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.sling.testing.mock.osgi.OsgiMetadataUtil;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

final class MapUtil {
    MapUtil() {
    }

    public static <T, U> Dictionary<T, U> toDictionary(Map<T, U> map) {
        if (map == null) {
            return null;
        }
        return new Hashtable<T, U>(map);
    }

    public static <T, U> Map<T, U> toMap(Dictionary<T, U> dictionary) {
        if (dictionary == null) {
            return null;
        }
        HashMap<T, U> map = new HashMap<T, U>();
        Enumeration<T> keys = dictionary.keys();
        while (keys.hasMoreElements()) {
            T key = keys.nextElement();
            map.put(key, dictionary.get(key));
        }
        return map;
    }

    public static Dictionary<String, Object> propertiesMergeWithOsgiMetadata(Object target, ConfigurationAdmin configAdmin, Dictionary<String, Object> properties) {
        return MapUtil.toDictionary(MapUtil.propertiesMergeWithOsgiMetadata(target, configAdmin, MapUtil.toMap(properties)));
    }

    public static Map<String, Object> propertiesMergeWithOsgiMetadata(Object target, ConfigurationAdmin configAdmin, Map<String, Object> properties) {
        Map<String, Object> metadataProperties;
        HashMap<String, Object> mergedProperties = new HashMap<String, Object>();
        OsgiMetadataUtil.OsgiMetadata metadata = OsgiMetadataUtil.getMetadata(target.getClass());
        if (metadata != null && (metadataProperties = metadata.getProperties()) != null) {
            Object pid;
            mergedProperties.putAll(metadataProperties);
            if (configAdmin != null && (pid = metadataProperties.get("service.pid")) != null) {
                try {
                    Configuration config = configAdmin.getConfiguration(pid.toString());
                    mergedProperties.putAll(MapUtil.toMap(config.getProperties()));
                }
                catch (IOException ex) {
                    throw new RuntimeException("Unable to read config for pid " + pid, ex);
                }
            }
        }
        if (properties != null) {
            mergedProperties.putAll(properties);
        }
        return mergedProperties;
    }
}

