/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi;

import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.ServiceUtil;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service(value={EventAdmin.class})
public final class MockEventAdmin
implements EventAdmin {
    @Reference(name="eventHandler", referenceInterface=EventHandler.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    private final Map<Object, EventHandlerItem> eventHandlers = new TreeMap<Object, EventHandlerItem>();
    private ExecutorService asyncHandler;
    private static final Logger log = LoggerFactory.getLogger(MockEventAdmin.class);

    @Activate
    protected void activate(ComponentContext componentContext) {
        this.asyncHandler = Executors.newCachedThreadPool();
    }

    @Deactivate
    protected void deactivate(ComponentContext componentContext) {
        this.asyncHandler.shutdownNow();
    }

    public void postEvent(final Event event) {
        this.asyncHandler.execute(new Runnable(){

            @Override
            public void run() {
                MockEventAdmin.this.distributeEvent(event);
            }
        });
    }

    public void sendEvent(Event event) {
        this.distributeEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void distributeEvent(Event event) {
        Map<Object, EventHandlerItem> map = this.eventHandlers;
        synchronized (map) {
            for (EventHandlerItem item : this.eventHandlers.values()) {
                if (!item.matches(event)) continue;
                try {
                    item.getEventHandler().handleEvent(event);
                }
                catch (Throwable ex) {
                    log.error("Error handlihng event {} in {}", (Object)event, (Object)item.getEventHandler());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindEventHandler(EventHandler eventHandler, Map<String, Object> props) {
        Map<Object, EventHandlerItem> map = this.eventHandlers;
        synchronized (map) {
            this.eventHandlers.put(ServiceUtil.getComparableForServiceRanking(props), new EventHandlerItem(eventHandler, props));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindEventHandler(EventHandler eventHandler, Map<String, Object> props) {
        Map<Object, EventHandlerItem> map = this.eventHandlers;
        synchronized (map) {
            this.eventHandlers.remove(ServiceUtil.getComparableForServiceRanking(props));
        }
    }

    private static class EventHandlerItem {
        private final EventHandler eventHandler;
        private final Pattern[] topicPatterns;
        private static final Pattern WILDCARD_PATTERN = Pattern.compile("[^*]+|(\\*)");

        public EventHandlerItem(EventHandler eventHandler, Map<String, Object> props) {
            this.eventHandler = eventHandler;
            this.topicPatterns = EventHandlerItem.generateTopicPatterns(props.get("event.topics"));
        }

        public boolean matches(Event event) {
            if (this.topicPatterns.length == 0) {
                return true;
            }
            String topic = event.getTopic();
            if (topic != null) {
                for (Pattern topicPattern : this.topicPatterns) {
                    if (!topicPattern.matcher(topic).matches()) continue;
                    return true;
                }
            }
            return false;
        }

        public EventHandler getEventHandler() {
            return this.eventHandler;
        }

        private static Pattern[] generateTopicPatterns(Object topic) {
            String[] topics;
            if (topic == null) {
                topics = new String[]{};
            } else if (topic instanceof String) {
                topics = new String[]{(String)topic};
            } else if (topic instanceof String[]) {
                topics = (String[])topic;
            } else {
                throw new IllegalArgumentException("Invalid topic: " + topic);
            }
            Pattern[] patterns = new Pattern[topics.length];
            for (int i = 0; i < topics.length; ++i) {
                patterns[i] = EventHandlerItem.toWildcardPattern(topics[i]);
            }
            return patterns;
        }

        private static Pattern toWildcardPattern(String wildcard) {
            Matcher matcher = WILDCARD_PATTERN.matcher(wildcard);
            StringBuffer result = new StringBuffer();
            while (matcher.find()) {
                if (matcher.group(1) != null) {
                    matcher.appendReplacement(result, ".*");
                    continue;
                }
                matcher.appendReplacement(result, "\\\\Q" + matcher.group(0) + "\\\\E");
            }
            matcher.appendTail(result);
            return Pattern.compile(result.toString());
        }
    }
}

