/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.resourceresolver;

import java.io.InputStream;
import java.util.Map;
import org.apache.sling.api.resource.AbstractResource;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ModifiableValueMapDecorator;
import org.apache.sling.testing.resourceresolver.MockResourceResolver;
import org.apache.sling.testing.resourceresolver.MockValueMap;

public class MockResource
extends AbstractResource {
    private final String path;
    private final ValueMap props;
    private final ResourceMetadata rm = new ResourceMetadata();
    private final ResourceResolver resolver;
    static final String JCR_PRIMARYTYPE = "jcr:primaryType";
    static final String JCR_CONTENT = "jcr:content";
    static final String JCR_DATA = "jcr:data";
    static final String NT_RESOURCE = "nt:resource";
    static final String NT_FILE = "nt:file";

    public MockResource(String path, Map<String, Object> props, ResourceResolver resolver) {
        this.path = path;
        this.props = props instanceof MockValueMap ? (MockValueMap)((Object)props) : new MockValueMap((Resource)this, props);
        this.resolver = resolver;
    }

    public String getPath() {
        return this.path;
    }

    public String getResourceType() {
        String resourceType = (String)this.props.get("sling:resourceType", String.class);
        if (resourceType == null) {
            resourceType = (String)this.props.get(JCR_PRIMARYTYPE, String.class);
        }
        return resourceType;
    }

    public String getResourceSuperType() {
        return (String)this.props.get("sling:resourceSuperType", String.class);
    }

    public ResourceMetadata getResourceMetadata() {
        return this.rm;
    }

    public ResourceResolver getResourceResolver() {
        return this.resolver;
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        InputStream is;
        if (type == ValueMap.class) {
            return (AdapterType)this.props;
        }
        if (type == ModifiableValueMap.class) {
            ((MockResourceResolver)this.resolver).addChanged(this.path, (Map<String, Object>)this.props);
            return (AdapterType)new ModifiableValueMapDecorator((Map)this.props);
        }
        if (type == InputStream.class && (is = this.getFileResourceInputStream()) != null) {
            return (AdapterType)is;
        }
        return (AdapterType)super.adaptTo(type);
    }

    private InputStream getFileResourceInputStream() {
        Resource contentResource;
        String resourceType = this.getResourceType();
        if (NT_RESOURCE.equals(resourceType)) {
            return (InputStream)this.getValueMap().get(JCR_DATA, InputStream.class);
        }
        if (NT_FILE.equals(resourceType) && (contentResource = this.getChild(JCR_CONTENT)) != null) {
            return (InputStream)ResourceUtil.getValueMap((Resource)contentResource).get(JCR_DATA, InputStream.class);
        }
        return null;
    }

    public ValueMap getValueMap() {
        return this.props;
    }

    public String toString() {
        return "MockResource [path=" + this.path + ", props=" + this.props + "]";
    }
}

