/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling;

import org.apache.sling.api.adapter.AdapterFactory;
import org.apache.sling.api.adapter.AdapterManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

class MockAdapterManager
implements AdapterManager {
    private BundleContext bundleContext;

    MockAdapterManager() {
    }

    public <AdapterType> AdapterType getAdapter(Object adaptable, Class<AdapterType> type) {
        if (this.bundleContext != null) {
            try {
                ServiceReference[] references;
                for (ServiceReference serviceReference : references = this.bundleContext.getServiceReferences(AdapterFactory.class.getName(), null)) {
                    AdapterFactory adapterFactory = (AdapterFactory)this.bundleContext.getService(serviceReference);
                    Object instance = adapterFactory.getAdapter(adaptable, type);
                    if (instance == null) continue;
                    return (AdapterType)instance;
                }
            }
            catch (InvalidSyntaxException ex) {
                throw new RuntimeException("Unable to get adapter factories.", ex);
            }
        }
        return null;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void clearBundleContext() {
        this.bundleContext = null;
    }
}

