/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling.loader;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.json.jcr.JsonItemWriter;
import org.apache.sling.commons.mime.MimeTypeService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public final class ContentLoader {
    private static final String REFERENCE = "jcr:reference:";
    private static final String PATH = "jcr:path:";
    private static final String CONTENTTYPE_OCTET_STREAM = "application/octet-stream";
    private static final String JCR_DATA_PLACEHOLDER = ":jcr:data";
    private static final Set<String> IGNORED_NAMES = ImmutableSet.of((Object)"jcr:primaryType", (Object)"jcr:mixinTypes", (Object)"jcr:uuid", (Object)"jcr:baseVersion", (Object)"jcr:predecessors", (Object)"jcr:successors", (Object[])new String[]{"jcr:created", "jcr:versionHistory", "jcr:checkedOut", "jcr:isCheckedOut", "rep:policy"});
    private final ResourceResolver resourceResolver;
    private final BundleContext bundleContext;
    private final DateFormat calendarFormat;

    public ContentLoader(ResourceResolver resourceResolver) {
        this(resourceResolver, null);
    }

    public ContentLoader(ResourceResolver resourceResolver, BundleContext bundleContext) {
        this.resourceResolver = resourceResolver;
        this.bundleContext = bundleContext;
        this.calendarFormat = new SimpleDateFormat("EEE MMM dd yyyy HH:mm:ss 'GMT'Z", JsonItemWriter.DATE_FORMAT_LOCALE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource json(String classpathResource, Resource parentResource, String childName) {
        InputStream is = ContentLoader.class.getResourceAsStream(classpathResource);
        if (is == null) {
            throw new IllegalArgumentException("Classpath resource not found: " + classpathResource);
        }
        try {
            Resource resource = this.json(is, parentResource, childName);
            return resource;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ex) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource json(String classpathResource, String destPath) {
        InputStream is = ContentLoader.class.getResourceAsStream(classpathResource);
        if (is == null) {
            throw new IllegalArgumentException("Classpath resource not found: " + classpathResource);
        }
        try {
            Resource resource = this.json(is, destPath);
            return resource;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ex) {}
        }
    }

    public Resource json(InputStream inputStream, Resource parentResource, String childName) {
        return this.json(inputStream, parentResource.getPath() + "/" + childName);
    }

    public Resource json(InputStream inputStream, String destPath) {
        try {
            String parentPath = ResourceUtil.getParent((String)destPath);
            String childName = ResourceUtil.getName((String)destPath);
            Resource parentResource = this.resourceResolver.getResource(parentPath);
            if (parentResource == null) {
                parentResource = this.createResourceHierarchy(parentPath);
            }
            if (parentResource.getChild(childName) != null) {
                throw new IllegalArgumentException("Resource does already exist: " + destPath);
            }
            String jsonString = this.convertToJsonString(inputStream).trim();
            JSONObject json = new JSONObject(jsonString);
            return this.createResource(parentResource, childName, json);
        }
        catch (JSONException ex) {
            throw new RuntimeException(ex);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private Resource createResourceHierarchy(String path) {
        String parentPath = ResourceUtil.getParent((String)path);
        if (parentPath == null) {
            return null;
        }
        Resource parentResource = this.resourceResolver.getResource(parentPath);
        if (parentResource == null) {
            parentResource = this.createResourceHierarchy(parentPath);
        }
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("jcr:primaryType", "nt:unstructured");
        try {
            return this.resourceResolver.create(parentResource, ResourceUtil.getName((String)path), props);
        }
        catch (PersistenceException ex) {
            throw new RuntimeException(ex);
        }
    }

    private Resource createResource(Resource parentResource, String childName, JSONObject jsonObject) throws IOException, JSONException {
        boolean hasJcrData = false;
        HashMap<String, Object> props = new HashMap<String, Object>();
        JSONArray names = jsonObject.names();
        for (int i = 0; names != null && i < names.length(); ++i) {
            Object obj;
            String name = names.getString(i);
            if (StringUtils.equals((CharSequence)name, (CharSequence)JCR_DATA_PLACEHOLDER)) {
                hasJcrData = true;
                continue;
            }
            if (IGNORED_NAMES.contains(name) || (obj = jsonObject.get(name)) instanceof JSONObject) continue;
            this.setProperty(props, name, obj);
        }
        Object primaryTypeObj = jsonObject.opt("jcr:primaryType");
        String primaryType = null;
        if (primaryTypeObj != null) {
            primaryType = String.valueOf(primaryTypeObj);
        }
        if (primaryType == null) {
            primaryType = "nt:unstructured";
        }
        props.put("jcr:primaryType", primaryType);
        Resource resource = this.resourceResolver.create(parentResource, childName, props);
        if (hasJcrData) {
            ModifiableValueMap valueMap = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class);
            valueMap.put((Object)"jcr:data", (Object)new ByteArrayInputStream(new byte[0]));
        }
        for (int i = 0; names != null && i < names.length(); ++i) {
            Object obj;
            String name = names.getString(i);
            if (IGNORED_NAMES.contains(name) || !((obj = jsonObject.get(name)) instanceof JSONObject)) continue;
            this.createResource(resource, name, (JSONObject)obj);
        }
        return resource;
    }

    private void setProperty(Map<String, Object> props, String name, Object value) throws JSONException {
        if (value instanceof JSONArray) {
            JSONArray array = (JSONArray)value;
            if (array.length() > 0) {
                Object[] values = new Object[array.length()];
                for (int i = 0; i < array.length(); ++i) {
                    values[i] = array.get(i);
                }
                if (values[0] instanceof Double || values[0] instanceof Float) {
                    Double[] arrayValues = new Double[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        arrayValues[i] = (Double)values[i];
                    }
                    props.put(this.cleanupJsonName(name), arrayValues);
                } else if (values[0] instanceof Number) {
                    Long[] arrayValues = new Long[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        arrayValues[i] = ((Number)values[i]).longValue();
                    }
                    props.put(this.cleanupJsonName(name), arrayValues);
                } else if (values[0] instanceof Boolean) {
                    Boolean[] arrayValues = new Boolean[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        arrayValues[i] = (Boolean)values[i];
                    }
                    props.put(this.cleanupJsonName(name), arrayValues);
                } else {
                    String[] arrayValues = new String[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        arrayValues[i] = values[i].toString();
                    }
                    props.put(this.cleanupJsonName(name), arrayValues);
                }
            } else {
                props.put(this.cleanupJsonName(name), new String[0]);
            }
        } else if (value instanceof Double || value instanceof Float) {
            props.put(this.cleanupJsonName(name), value);
        } else if (value instanceof Number) {
            props.put(this.cleanupJsonName(name), ((Number)value).longValue());
        } else if (value instanceof Boolean) {
            props.put(this.cleanupJsonName(name), value);
        } else {
            String stringValue = value.toString();
            Calendar calendar = this.tryParseCalendarValue(stringValue);
            if (calendar != null) {
                props.put(this.cleanupJsonName(name), calendar);
            } else {
                props.put(this.cleanupJsonName(name), stringValue);
            }
        }
    }

    private String cleanupJsonName(String name) {
        if (name.startsWith(REFERENCE)) {
            return name.substring(REFERENCE.length());
        }
        if (name.startsWith(PATH)) {
            return name.substring(PATH.length());
        }
        return name;
    }

    private String convertToJsonString(InputStream inputStream) {
        try {
            String string = IOUtils.toString((InputStream)inputStream);
            return string;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException ex) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Calendar tryParseCalendarValue(String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            DateFormat dateFormat = this.calendarFormat;
            synchronized (dateFormat) {
                try {
                    Date date = this.calendarFormat.parse(value);
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(date);
                    return calendar;
                }
                catch (ParseException parseException) {
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource binaryFile(String classpathResource, String path) {
        InputStream is = ContentLoader.class.getResourceAsStream(classpathResource);
        if (is == null) {
            throw new IllegalArgumentException("Classpath resource not found: " + classpathResource);
        }
        try {
            Resource resource = this.binaryFile(is, path, this.detectMimeTypeFromName(path));
            return resource;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ex) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource binaryFile(String classpathResource, String path, String mimeType) {
        InputStream is = ContentLoader.class.getResourceAsStream(classpathResource);
        if (is == null) {
            throw new IllegalArgumentException("Classpath resource not found: " + classpathResource);
        }
        try {
            Resource resource = this.binaryFile(is, path, mimeType);
            return resource;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ex) {}
        }
    }

    public Resource binaryFile(InputStream inputStream, String path) {
        return this.binaryFile(inputStream, path, this.detectMimeTypeFromName(path));
    }

    public Resource binaryFile(InputStream inputStream, String path, String mimeType) {
        String parentPath = ResourceUtil.getParent((String)path, (int)1);
        String name = ResourceUtil.getName((String)path);
        Resource parentResource = this.resourceResolver.getResource(parentPath);
        if (parentResource == null) {
            parentResource = this.createResourceHierarchy(parentPath);
        }
        return this.binaryFile(inputStream, parentResource, name, mimeType);
    }

    public Resource binaryFile(InputStream inputStream, Resource parentResource, String name) {
        return this.binaryFile(inputStream, parentResource, name, this.detectMimeTypeFromName(name));
    }

    public Resource binaryFile(InputStream inputStream, Resource parentResource, String name, String mimeType) {
        try {
            Resource file = this.resourceResolver.create(parentResource, name, (Map)ImmutableMap.builder().put((Object)"jcr:primaryType", (Object)"nt:file").build());
            this.resourceResolver.create(file, "jcr:content", (Map)ImmutableMap.builder().put((Object)"jcr:primaryType", (Object)"nt:resource").put((Object)"jcr:data", (Object)inputStream).put((Object)"jcr:mimeType", (Object)mimeType).build());
            return file;
        }
        catch (PersistenceException ex) {
            throw new RuntimeException("Unable to create resource at " + parentResource.getPath() + "/" + name, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource binaryResource(String classpathResource, String path) {
        InputStream is = ContentLoader.class.getResourceAsStream(classpathResource);
        if (is == null) {
            throw new IllegalArgumentException("Classpath resource not found: " + classpathResource);
        }
        try {
            Resource resource = this.binaryResource(is, path, this.detectMimeTypeFromName(path));
            return resource;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ex) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource binaryResource(String classpathResource, String path, String mimeType) {
        InputStream is = ContentLoader.class.getResourceAsStream(classpathResource);
        if (is == null) {
            throw new IllegalArgumentException("Classpath resource not found: " + classpathResource);
        }
        try {
            Resource resource = this.binaryResource(is, path, mimeType);
            return resource;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ex) {}
        }
    }

    public Resource binaryResource(InputStream inputStream, String path) {
        return this.binaryResource(inputStream, path, this.detectMimeTypeFromName(path));
    }

    public Resource binaryResource(InputStream inputStream, String path, String mimeType) {
        String parentPath = ResourceUtil.getParent((String)path, (int)1);
        String name = ResourceUtil.getName((String)path);
        Resource parentResource = this.resourceResolver.getResource(parentPath);
        if (parentResource == null) {
            parentResource = this.createResourceHierarchy(parentPath);
        }
        return this.binaryResource(inputStream, parentResource, name, mimeType);
    }

    public Resource binaryResource(InputStream inputStream, Resource parentResource, String name) {
        return this.binaryResource(inputStream, parentResource, name, this.detectMimeTypeFromName(name));
    }

    public Resource binaryResource(InputStream inputStream, Resource parentResource, String name, String mimeType) {
        try {
            return this.resourceResolver.create(parentResource, name, (Map)ImmutableMap.builder().put((Object)"jcr:primaryType", (Object)"nt:resource").put((Object)"jcr:data", (Object)inputStream).put((Object)"jcr:mimeType", (Object)mimeType).build());
        }
        catch (PersistenceException ex) {
            throw new RuntimeException("Unable to create resource at " + parentResource.getPath() + "/" + name, ex);
        }
    }

    private String detectMimeTypeFromName(String name) {
        ServiceReference ref;
        String mimeType = null;
        String fileExtension = StringUtils.substringAfterLast((String)name, (String)".");
        if (this.bundleContext != null && StringUtils.isNotEmpty((CharSequence)fileExtension) && (ref = this.bundleContext.getServiceReference(MimeTypeService.class.getName())) != null) {
            MimeTypeService mimeTypeService = (MimeTypeService)this.bundleContext.getService(ref);
            mimeType = mimeTypeService.getMimeType(fileExtension);
        }
        return StringUtils.defaultString(mimeType, (String)CONTENTTYPE_OCTET_STREAM);
    }
}

