/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling.context;

import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.testing.mock.sling.MockSling;
import org.apache.sling.testing.mock.sling.ResourceResolverType;
import org.osgi.framework.BundleContext;

final class ContextResourceResolverFactory {
    private ContextResourceResolverFactory() {
    }

    public static ResourceResolverFactory get(ResourceResolverType resourceResolverType, BundleContext bundleContext) {
        ResourceResolverType type = resourceResolverType;
        if (type == null) {
            type = MockSling.DEFAULT_RESOURCERESOLVER_TYPE;
        }
        try {
            ResourceResolverFactory factory = MockSling.newResourceResolverFactory(type, bundleContext);
            switch (type) {
                case JCR_MOCK: {
                    ContextResourceResolverFactory.initializeJcrMock(factory);
                    break;
                }
                case JCR_JACKRABBIT: {
                    ContextResourceResolverFactory.initializeJcrJackrabbit(factory);
                    break;
                }
                case JCR_OAK: {
                    ContextResourceResolverFactory.initializeJcrOak(factory);
                    break;
                }
                case RESOURCERESOLVER_MOCK: {
                    ContextResourceResolverFactory.initializeResourceResolverMock(factory);
                    break;
                }
                case NONE: {
                    ContextResourceResolverFactory.initializeResourceResolverNone(factory);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid resource resolver type: " + (Object)((Object)type));
                }
            }
            return factory;
        }
        catch (Throwable ex) {
            throw new RuntimeException("Unable to initialize " + (Object)((Object)type) + " resource resolver factory.", ex);
        }
    }

    private static void initializeJcrMock(ResourceResolverFactory factory) throws RepositoryException, LoginException {
    }

    private static void initializeJcrJackrabbit(ResourceResolverFactory factory) {
    }

    private static void initializeJcrOak(ResourceResolverFactory factory) {
    }

    private static void initializeResourceResolverMock(ResourceResolverFactory factory) {
    }

    private static void initializeResourceResolverNone(ResourceResolverFactory factory) {
    }
}

