/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling.servlet;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;
import org.apache.commons.collections.IteratorUtils;
import org.apache.sling.testing.mock.sling.servlet.MockServletContext;

public final class MockHttpSession
implements HttpSession {
    private final ServletContext servletContext = new MockServletContext();
    private final Map<String, Object> attributeMap = new HashMap<String, Object>();
    private final String sessionID = UUID.randomUUID().toString();
    private final long creationTime = System.currentTimeMillis();

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public Object getAttribute(String name) {
        return this.attributeMap.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        return IteratorUtils.asEnumeration(this.attributeMap.keySet().iterator());
    }

    public String getId() {
        return this.sessionID;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    public String[] getValueNames() {
        return this.attributeMap.keySet().toArray(new String[this.attributeMap.keySet().size()]);
    }

    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        this.attributeMap.remove(name);
    }

    public void removeValue(String name) {
        this.attributeMap.remove(name);
    }

    public void setAttribute(String name, Object value) {
        this.attributeMap.put(name, value);
    }

    public long getLastAccessedTime() {
        throw new UnsupportedOperationException();
    }

    public int getMaxInactiveInterval() {
        throw new UnsupportedOperationException();
    }

    public HttpSessionContext getSessionContext() {
        throw new UnsupportedOperationException();
    }

    public void invalidate() {
        throw new UnsupportedOperationException();
    }

    public boolean isNew() {
        throw new UnsupportedOperationException();
    }

    public void setMaxInactiveInterval(int interval) {
        throw new UnsupportedOperationException();
    }
}

