/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling;

import java.util.Dictionary;
import java.util.Hashtable;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.resource.ResourceProviderFactory;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrResourceProviderFactory;
import org.apache.sling.resourceresolver.impl.ResourceAccessSecurityTracker;
import org.apache.sling.resourceresolver.impl.ResourceResolverFactoryActivator;
import org.apache.sling.serviceusermapping.ServiceUserMapper;
import org.apache.sling.serviceusermapping.impl.ServiceUserMapperImpl;
import org.apache.sling.testing.mock.osgi.MockEventAdmin;
import org.apache.sling.testing.mock.osgi.MockOsgi;
import org.apache.sling.testing.mock.sling.NodeTypeDefinitionScanner;
import org.apache.sling.testing.mock.sling.NodeTypeMode;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.EventAdmin;

class ResourceResolverFactoryInitializer {
    private ResourceResolverFactoryInitializer() {
    }

    public static ResourceResolverFactory setUp(SlingRepository slingRepository, BundleContext bundleContext, NodeTypeMode nodeTypeMode) {
        if (slingRepository != null) {
            ResourceResolverFactoryInitializer.registerServiceIfNotPresent(bundleContext, SlingRepository.class, slingRepository);
            ResourceResolverFactoryInitializer.registerJcrNodeTypes(slingRepository, nodeTypeMode);
            ResourceResolverFactoryInitializer.ensureJcrResourceProviderFactoryDependencies(bundleContext);
            ResourceResolverFactoryInitializer.initializeJcrResourceProviderFactory(bundleContext);
        }
        ResourceResolverFactoryInitializer.ensureResourceResolverFactoryActivatorDependencies(bundleContext);
        ResourceResolverFactoryInitializer.initializeResourceResolverFactoryActivator(bundleContext);
        ServiceReference factoryRef = bundleContext.getServiceReference(ResourceResolverFactory.class.getName());
        if (factoryRef == null) {
            throw new IllegalStateException("Unable to get ResourceResolverFactory.");
        }
        return (ResourceResolverFactory)bundleContext.getService(factoryRef);
    }

    private static void ensureJcrResourceProviderFactoryDependencies(BundleContext bundleContext) {
        ResourceResolverFactoryInitializer.registerServiceIfFoundInClasspath(bundleContext, "org.apache.sling.jcr.resource.internal.helper.jcr.PathMapper");
    }

    private static void initializeJcrResourceProviderFactory(BundleContext bundleContext) {
        Hashtable<String, String[]> config = new Hashtable<String, String[]>();
        ((Dictionary)config).put("provider.roots", new String[]{"/"});
        ((Dictionary)config).put("provider.query.languages", new String[]{"xpath", "sql", "JCR-SQL2"});
        JcrResourceProviderFactory factory = new JcrResourceProviderFactory();
        MockOsgi.injectServices((Object)factory, (BundleContext)bundleContext);
        MockOsgi.activate((Object)factory, (BundleContext)bundleContext, config);
        bundleContext.registerService(ResourceProviderFactory.class.getName(), (Object)factory, config);
    }

    private static void ensureResourceResolverFactoryActivatorDependencies(BundleContext bundleContext) {
        Hashtable<String, Object> config = new Hashtable<String, Object>();
        ((Dictionary)config).put("user.mapping", bundleContext.getBundle().getSymbolicName() + "=admin");
        ResourceResolverFactoryInitializer.registerServiceIfNotPresent(bundleContext, ServiceUserMapper.class, new ServiceUserMapperImpl(), config);
        ResourceResolverFactoryInitializer.registerServiceIfNotPresent(bundleContext, ResourceAccessSecurityTracker.class, new ResourceAccessSecurityTracker());
        ResourceResolverFactoryInitializer.registerServiceIfNotPresent(bundleContext, EventAdmin.class, new MockEventAdmin());
    }

    private static void initializeResourceResolverFactoryActivator(BundleContext bundleContext) {
        Hashtable<String, String[]> config = new Hashtable<String, String[]>();
        ((Dictionary)config).put("resource.resolver.required.providers", new String[0]);
        ResourceResolverFactoryActivator activator = new ResourceResolverFactoryActivator();
        MockOsgi.injectServices((Object)activator, (BundleContext)bundleContext);
        MockOsgi.activate((Object)activator, (BundleContext)bundleContext, config);
        bundleContext.registerService(ResourceResolverFactoryActivator.class.getName(), (Object)activator, config);
    }

    private static void registerServiceIfNotPresent(BundleContext bundleContext, Class<?> serviceClass, Object instance) {
        ResourceResolverFactoryInitializer.registerServiceIfNotPresent(bundleContext, serviceClass, instance, new Hashtable<String, Object>());
    }

    private static void registerServiceIfNotPresent(BundleContext bundleContext, Class<?> serviceClass, Object instance, Dictionary<String, Object> config) {
        if (bundleContext.getServiceReference(serviceClass.getName()) == null) {
            MockOsgi.injectServices((Object)instance, (BundleContext)bundleContext);
            MockOsgi.activate((Object)instance, (BundleContext)bundleContext, config);
            bundleContext.registerService(serviceClass.getName(), instance, config);
        }
    }

    private static void registerServiceIfFoundInClasspath(BundleContext bundleContext, String className) {
        try {
            Class<?> serviceClass = Class.forName(className);
            Object instance = serviceClass.newInstance();
            ResourceResolverFactoryInitializer.registerServiceIfNotPresent(bundleContext, serviceClass, instance);
        }
        catch (ClassNotFoundException ex) {
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    private static void registerJcrNodeTypes(SlingRepository slingRepository, NodeTypeMode nodeTypeMode) {
        Session session = null;
        try {
            session = slingRepository.loginAdministrative(null);
            NodeTypeDefinitionScanner.get().register(session, nodeTypeMode);
        }
        catch (RepositoryException ex) {
            throw new RuntimeException("Error registering JCR nodetypes: " + ex.getMessage(), ex);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }
}

