/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling.builder;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;

public class ContentBuilder {
    static final String DUMMY_TEMPLATE = "/apps/sample/templates/template1";
    protected final ResourceResolver resourceResolver;

    public ContentBuilder(ResourceResolver resourceResolver) {
        this.resourceResolver = resourceResolver;
    }

    public final Resource resource(String path) {
        return this.resource(path, (Map<String, Object>)ValueMap.EMPTY);
    }

    public final Resource resource(String path, Map<String, Object> properties) {
        String parentPath = ResourceUtil.getParent((String)path);
        Resource parentResource = this.ensureResourceExists(parentPath);
        String name = ResourceUtil.getName((String)path);
        try {
            return this.resourceResolver.create(parentResource, name, properties);
        }
        catch (PersistenceException ex) {
            throw new RuntimeException("Unable to create resource at " + path, ex);
        }
    }

    protected final Resource ensureResourceExists(String path) {
        if (StringUtils.isEmpty((CharSequence)path) || StringUtils.equals((CharSequence)path, (CharSequence)"/")) {
            return this.resourceResolver.getResource("/");
        }
        Resource resource = this.resourceResolver.getResource(path);
        if (resource != null) {
            return resource;
        }
        String parentPath = ResourceUtil.getParent((String)path);
        String name = ResourceUtil.getName((String)path);
        Resource parentResource = this.ensureResourceExists(parentPath);
        try {
            resource = this.resourceResolver.create(parentResource, name, (Map)ImmutableMap.builder().put((Object)"jcr:primaryType", (Object)"nt:unstructured").build());
            this.resourceResolver.commit();
            return resource;
        }
        catch (PersistenceException ex) {
            throw new RuntimeException("Unable to create resource at " + path, ex);
        }
    }
}

