/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.tools.junit;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

@Component
@Service
@Property(name="pattern", value={"/.*"})
public class TestNameLoggingFilter
implements Filter {
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
        String className = httpRequest.getHeader("X-Sling-Test-Class");
        if (className == null) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        String testName = httpRequest.getHeader("X-Sling-Test-Name");
        try {
            MDC.put((String)"X-Sling-Test-Name", (String)testName);
            MDC.put((String)"X-Sling-Test-Class", (String)className);
            this.log.info("Starting request as part of test ==== {}.{} ====", (Object)className, (Object)testName);
            filterChain.doFilter(servletRequest, servletResponse);
        }
        finally {
            this.log.info("Finishing request as part of test ==== {}.{} ====", (Object)className, (Object)testName);
            MDC.remove((String)"X-Sling-Test-Name");
            MDC.remove((String)"X-Sling-Test-Class");
        }
    }

    public void destroy() {
    }
}

