/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.xss.impl;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.json.Json;
import javax.json.JsonReaderFactory;
import javax.json.JsonValue;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.xss.ProtectionContext;
import org.apache.sling.xss.XSSAPI;
import org.apache.sling.xss.XSSFilter;
import org.apache.sling.xss.impl.LongValidationRule;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.owasp.encoder.Encode;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

@Component(service={XSSAPI.class}, property={"service.vendor=The Apache Software Foundation"})
public class XSSAPIImpl
implements XSSAPI {
    private final Logger LOGGER = LoggerFactory.getLogger(XSSAPIImpl.class);
    @Reference
    private XSSFilter xssFilter;
    private final Validator validator = ESAPI.validator();
    private static final Pattern PATTERN_AUTO_DIMENSION = Pattern.compile("['\"]?auto['\"]?");
    private SAXParserFactory factory;
    private volatile JsonReaderFactory jsonReaderFactory;
    private static final String MANGLE_NAMESPACE_OUT_SUFFIX = ":";
    private static final String MANGLE_NAMESPACE_OUT = "/([^:/]+):";
    private static final Pattern MANGLE_NAMESPACE_PATTERN = Pattern.compile("/([^:/]+):");
    private static final String MANGLE_NAMESPACE_IN_SUFFIX = "_";
    private static final String MANGLE_NAMESPACE_IN_PREFIX = "/_";
    private static final String NON_ASCII = "\\x00\\x08\\x0B\\x0C\\x0E-\\x1F";
    private static final String NUMBER = "[+-]?[\\d]*[\\.]?[\\d]*(?:[e][+-]?\\d+)?";
    private static final String HEX_DIGITS = "#[0-9a-f]*";
    private static final String IDENTIFIER = "-?[a-z_\\x00\\x08\\x0B\\x0C\\x0E-\\x1F][\\w_\\-\\x00\\x08\\x0B\\x0C\\x0E-\\x1F]*";
    private static final String STRING = "\"(?:(?!javascript\\s?:)[^\"^\\\\^\\n]|(?:\\\\\"))*\"|'(?:(?!javascript\\s?:)[^'^\\\\^\\n]|(?:\\\\'))*'";
    private static final String DIMENSION = "[+-]?[\\d]*[\\.]?[\\d]*(?:[e][+-]?\\d+)?-?[a-z_\\x00\\x08\\x0B\\x0C\\x0E-\\x1F][\\w_\\-\\x00\\x08\\x0B\\x0C\\x0E-\\x1F]*";
    private static final String PERCENT = "[+-]?[\\d]*[\\.]?[\\d]*(?:[e][+-]?\\d+)?%";
    private static final String FUNCTION = "-?[a-z_\\x00\\x08\\x0B\\x0C\\x0E-\\x1F][\\w_\\-\\x00\\x08\\x0B\\x0C\\x0E-\\x1F]*\\((?:(?:[+-]?[\\d]*[\\.]?[\\d]*(?:[e][+-]?\\d+)?)|(?:-?[a-z_\\x00\\x08\\x0B\\x0C\\x0E-\\x1F][\\w_\\-\\x00\\x08\\x0B\\x0C\\x0E-\\x1F]*)|(?:[\\s]*)|(?:,))*\\)";
    private static final String URL_UNQUOTED = "[^\"^'^\\(^\\)^[\\x00\\x08\\x0B\\x0C\\x0E-\\x1F]]*";
    private static final String URL = "url\\((?:(?:[^\"^'^\\(^\\)^[\\x00\\x08\\x0B\\x0C\\x0E-\\x1F]]*)|(?:\"(?:(?!javascript\\s?:)[^\"^\\\\^\\n]|(?:\\\\\"))*\"|'(?:(?!javascript\\s?:)[^'^\\\\^\\n]|(?:\\\\'))*'))\\)";
    private static final String CSS_TOKEN = "(?i)(?:[+-]?[\\d]*[\\.]?[\\d]*(?:[e][+-]?\\d+)?)|(?:[+-]?[\\d]*[\\.]?[\\d]*(?:[e][+-]?\\d+)?-?[a-z_\\x00\\x08\\x0B\\x0C\\x0E-\\x1F][\\w_\\-\\x00\\x08\\x0B\\x0C\\x0E-\\x1F]*)|(?:[+-]?[\\d]*[\\.]?[\\d]*(?:[e][+-]?\\d+)?%)|(?:#[0-9a-f]*)|(?:-?[a-z_\\x00\\x08\\x0B\\x0C\\x0E-\\x1F][\\w_\\-\\x00\\x08\\x0B\\x0C\\x0E-\\x1F]*)|(?:\"(?:(?!javascript\\s?:)[^\"^\\\\^\\n]|(?:\\\\\"))*\"|'(?:(?!javascript\\s?:)[^'^\\\\^\\n]|(?:\\\\'))*')|(?:-?[a-z_\\x00\\x08\\x0B\\x0C\\x0E-\\x1F][\\w_\\-\\x00\\x08\\x0B\\x0C\\x0E-\\x1F]*\\((?:(?:[+-]?[\\d]*[\\.]?[\\d]*(?:[e][+-]?\\d+)?)|(?:-?[a-z_\\x00\\x08\\x0B\\x0C\\x0E-\\x1F][\\w_\\-\\x00\\x08\\x0B\\x0C\\x0E-\\x1F]*)|(?:[\\s]*)|(?:,))*\\))|(?:url\\((?:(?:[^\"^'^\\(^\\)^[\\x00\\x08\\x0B\\x0C\\x0E-\\x1F]]*)|(?:\"(?:(?!javascript\\s?:)[^\"^\\\\^\\n]|(?:\\\\\"))*\"|'(?:(?!javascript\\s?:)[^'^\\\\^\\n]|(?:\\\\'))*'))\\))";

    @Activate
    protected void activate() {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.factory = SAXParserFactory.newInstance();
            this.factory.setValidating(false);
            this.factory.setNamespaceAware(true);
            try {
                this.factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                this.factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                this.factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            }
            catch (Exception e) {
                this.LOGGER.error("SAX parser configuration error: " + e.getMessage(), (Throwable)e);
            }
            HashMap<String, Boolean> config = new HashMap<String, Boolean>();
            config.put("org.apache.johnzon.supports-comments", true);
            this.jsonReaderFactory = Json.createReaderFactory(config);
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    @Deactivate
    protected void deactivate() {
        this.factory = null;
        this.jsonReaderFactory = null;
    }

    @Override
    public Integer getValidInteger(String integer, int defaultValue) {
        if (integer != null && integer.length() > 0) {
            try {
                return this.validator.getValidInteger("XSS", integer, -2000000000, 2000000000, false);
            }
            catch (Exception e) {
                this.LOGGER.warn("Unable to get a valid integer from the input.", (Throwable)e);
                this.LOGGER.debug("Integer input: {}", (Object)integer);
            }
        }
        return defaultValue;
    }

    @Override
    public Long getValidLong(String source, long defaultValue) {
        if (source != null && source.length() > 0) {
            try {
                LongValidationRule ivr = new LongValidationRule("number", ESAPI.encoder(), -9000000000000000000L, 9000000000000000000L);
                ivr.setAllowNull(false);
                return ivr.getValid("XSS", source);
            }
            catch (Exception e) {
                this.LOGGER.warn("Unable to get a valid long from the input.", (Throwable)e);
                this.LOGGER.debug("Long input: {}", (Object)source);
            }
        }
        return defaultValue;
    }

    @Override
    public Double getValidDouble(String source, double defaultValue) {
        if (source != null && source.length() > 0) {
            try {
                return this.validator.getValidDouble("XSS", source, 0.0, Double.MAX_VALUE, false);
            }
            catch (Exception e) {
                this.LOGGER.warn("Unable to get a valid double from the input.", (Throwable)e);
                this.LOGGER.debug("Double input: {}", (Object)source);
            }
        }
        return defaultValue;
    }

    @Override
    public String getValidDimension(String dimension, String defaultValue) {
        if (dimension != null && dimension.length() > 0) {
            if (PATTERN_AUTO_DIMENSION.matcher(dimension).matches()) {
                return "\"auto\"";
            }
            try {
                return this.validator.getValidInteger("XSS", dimension, -10000, 10000, false).toString();
            }
            catch (Exception e) {
                this.LOGGER.warn("Unable to get a valid dimension from the input.", (Throwable)e);
                this.LOGGER.debug("Dimension input: {}", (Object)dimension);
            }
        }
        return defaultValue;
    }

    private String mangleNamespaces(String absPath) throws URISyntaxException, UnsupportedEncodingException {
        String mangledPath = null;
        URI uri = new URI(absPath);
        if (uri.getPath() != null && uri.getRawPath().contains(MANGLE_NAMESPACE_OUT_SUFFIX)) {
            Matcher m = MANGLE_NAMESPACE_PATTERN.matcher(uri.getRawPath());
            StringBuffer buf = new StringBuffer();
            while (m.find()) {
                String replacement = MANGLE_NAMESPACE_IN_PREFIX + m.group(1) + MANGLE_NAMESPACE_IN_SUFFIX;
                m.appendReplacement(buf, replacement);
            }
            m.appendTail(buf);
            mangledPath = buf.toString();
        }
        if (mangledPath != null) {
            URI mangledURI = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), URLDecoder.decode(mangledPath, "UTF-8"), uri.getQuery(), uri.getFragment());
            StringBuilder uriBuilder = new StringBuilder();
            if (StringUtils.isNotEmpty((CharSequence)mangledURI.getScheme()) && StringUtils.isNotEmpty((CharSequence)mangledURI.getAuthority())) {
                uriBuilder.append(mangledURI.getScheme()).append("://").append(mangledURI.getRawAuthority());
            }
            if (StringUtils.isNotEmpty((CharSequence)mangledURI.getPath())) {
                uriBuilder.append(mangledURI.getRawPath());
            }
            if (StringUtils.isNotEmpty((CharSequence)mangledURI.getQuery())) {
                uriBuilder.append("?").append(mangledURI.getRawQuery());
            }
            if (StringUtils.isNotEmpty((CharSequence)mangledURI.getFragment())) {
                uriBuilder.append("#").append(mangledURI.getRawFragment());
            }
            return uriBuilder.toString();
        }
        return absPath;
    }

    @Override
    @NotNull
    public String getValidHref(String url) {
        if (StringUtils.isNotEmpty((CharSequence)url)) {
            String encodedUrl = url.replaceAll("\"", "%22").replaceAll("'", "%27").replaceAll(">", "%3E").replaceAll("<", "%3C").replaceAll("`", "%60").replaceAll(" ", "%20");
            try {
                encodedUrl = this.mangleNamespaces(encodedUrl);
                if (this.xssFilter.isValidHref(encodedUrl)) {
                    return encodedUrl;
                }
            }
            catch (Throwable t) {
                this.LOGGER.warn("Unable to validate URL.", t);
                this.LOGGER.debug("Passed URL: {}", (Object)url);
            }
        }
        return "";
    }

    @Override
    public String getValidJSToken(String token, String defaultValue) {
        if (token != null && token.length() > 0) {
            String q = (token = token.trim()).substring(0, 1);
            if (q.matches("['\"]") && token.endsWith(q)) {
                String literal = token.substring(1, token.length() - 1);
                return q + this.encodeForJSString(literal) + q;
            }
            if (token.matches("[0-9a-zA-Z_$][0-9a-zA-Z_$.]*")) {
                return token;
            }
        }
        return defaultValue;
    }

    @Override
    public String getValidStyleToken(String token, String defaultValue) {
        if (token != null && token.length() > 0 && token.matches(CSS_TOKEN)) {
            return token;
        }
        return defaultValue;
    }

    @Override
    public String getValidCSSColor(String color, String defaultColor) {
        if (color != null && color.length() > 0) {
            if ((color = color.trim()).matches("(?i)[#a-fghlrs(+0-9-.%,) \\t\\n\\x0B\\f\\r]+")) {
                return color;
            }
            if (color.matches("(?i)[a-zA-Z \\t\\n\\x0B\\f\\r]+")) {
                return color;
            }
        }
        return defaultColor;
    }

    @Override
    public String getValidMultiLineComment(String comment, String defaultComment) {
        if (comment != null && !comment.contains("*/")) {
            return comment;
        }
        return defaultComment;
    }

    @Override
    public String getValidJSON(String json, String defaultJson) {
        if (json == null) {
            return this.getValidJSON(defaultJson, "");
        }
        if ("".equals(json = json.trim())) {
            return "";
        }
        int curlyIx = json.indexOf("{");
        int straightIx = json.indexOf("[");
        if (curlyIx >= 0 && (curlyIx < straightIx || straightIx < 0)) {
            try {
                StringWriter output = new StringWriter();
                Json.createGenerator((Writer)output).write((JsonValue)this.jsonReaderFactory.createReader((Reader)new StringReader(json)).readObject()).close();
                return output.getBuffer().toString();
            }
            catch (Exception e) {
                this.LOGGER.warn("Unable to get valid JSON from the input.", (Throwable)e);
                this.LOGGER.debug("JSON input:\n{}", (Object)json);
            }
        } else {
            try {
                StringWriter output = new StringWriter();
                Json.createGenerator((Writer)output).write((JsonValue)this.jsonReaderFactory.createReader((Reader)new StringReader(json)).readArray()).close();
                return output.getBuffer().toString();
            }
            catch (Exception e) {
                this.LOGGER.warn("Unable to get valid JSON from the input.", (Throwable)e);
                this.LOGGER.debug("JSON input:\n{}", (Object)json);
            }
        }
        return this.getValidJSON(defaultJson, "");
    }

    @Override
    public String getValidXML(String xml, String defaultXml) {
        if (xml == null) {
            return this.getValidXML(defaultXml, "");
        }
        if ("".equals(xml = xml.trim())) {
            return "";
        }
        try {
            SAXParser parser = this.factory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            reader.parse(new InputSource(new StringReader(xml)));
            return xml;
        }
        catch (Exception e) {
            this.LOGGER.warn("Unable to get valid XML from the input.", (Throwable)e);
            this.LOGGER.debug("XML input:\n{}", (Object)xml);
            return this.getValidXML(defaultXml, "");
        }
    }

    @Override
    public String encodeForHTML(String source) {
        return source == null ? null : Encode.forHtml(source);
    }

    @Override
    public String encodeForHTMLAttr(String source) {
        return source == null ? null : Encode.forHtmlAttribute(source);
    }

    @Override
    public String encodeForXML(String source) {
        return source == null ? null : Encode.forXml(source);
    }

    @Override
    public String encodeForXMLAttr(String source) {
        return source == null ? null : Encode.forXmlAttribute(source);
    }

    @Override
    public String encodeForJSString(String source) {
        return source == null ? null : Encode.forJavaScript(source).replace("\\-", "\\u002D");
    }

    @Override
    public String encodeForCSSString(String source) {
        return source == null ? null : Encode.forCssString(source);
    }

    @Override
    @NotNull
    public String filterHTML(String source) {
        return this.xssFilter.filter(ProtectionContext.HTML_HTML_CONTENT, source);
    }
}

