/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.transform;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.IOUtils;

final class FactoryFinder {
    private static boolean debug = false;

    private FactoryFinder() {
    }

    private static void dPrint(String msg) {
        if (debug) {
            System.err.println("JAXP: " + msg);
        }
    }

    static Object newInstance(String className, ClassLoader cl, boolean doFallback) throws ConfigurationError {
        try {
            Class<?> providerClass;
            if (cl == null) {
                providerClass = Class.forName(className);
            } else {
                try {
                    providerClass = cl.loadClass(className);
                }
                catch (ClassNotFoundException x) {
                    if (doFallback) {
                        cl = FactoryFinder.class.getClassLoader();
                        providerClass = cl != null ? cl.loadClass(className) : Class.forName(className);
                    }
                    throw x;
                }
            }
            Object instance = providerClass.newInstance();
            if (debug) {
                FactoryFinder.dPrint("created new instance of " + providerClass + " using ClassLoader: " + cl);
            }
            return instance;
        }
        catch (ClassNotFoundException x) {
            throw new ConfigurationError("Provider " + className + " not found", x);
        }
        catch (Exception x) {
            throw new ConfigurationError("Provider " + className + " could not be instantiated: " + x, x);
        }
    }

    static Object find(String factoryId, String fallbackClassName) throws ConfigurationError {
        Object instance;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = FactoryFinder.class.getClassLoader();
        }
        if ((instance = FactoryFinder.loadFactoryFromServiceFile(factoryId, classLoader)) != null) {
            return instance;
        }
        if (debug) {
            FactoryFinder.dPrint("loaded from fallback value: " + fallbackClassName);
        }
        return FactoryFinder.newInstance(fallbackClassName, classLoader, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object loadFactoryFromServiceFile(String factoryId, ClassLoader classLoader) {
        try {
            Enumeration<URL> serviceFiles = classLoader.getResources("/META-INF/services/" + factoryId);
            while (serviceFiles.hasMoreElements()) {
                URL url = serviceFiles.nextElement();
                if (debug) {
                    FactoryFinder.dPrint("Inspecting service file " + url);
                }
                InputStream is = url.openStream();
                try {
                    List lines = IOUtils.readLines((InputStream)is, (Charset)StandardCharsets.UTF_8);
                    Optional<String> service = lines.stream().filter(s -> !s.trim().startsWith("#")).filter(s -> !s.trim().isEmpty()).findFirst();
                    if (!service.isPresent()) continue;
                    try {
                        Object object = FactoryFinder.newInstance(service.get(), classLoader, true);
                        return object;
                    }
                    catch (ConfigurationError configurationError) {}
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            return null;
        }
        catch (IOException e) {
            if (!debug) return null;
            FactoryFinder.dPrint("Failed loading service files " + e.getMessage());
            e.printStackTrace(System.err);
        }
        return null;
    }

    static {
        try {
            String val = System.getProperty("jaxp.debug");
            debug = val != null && !"false".equals(val);
        }
        catch (SecurityException se) {
            debug = false;
        }
    }

    static class ConfigurationError
    extends Error {
        private Exception exception;

        ConfigurationError(String msg, Exception x) {
            super(msg);
            this.exception = x;
        }

        Exception getException() {
            return this.exception;
        }
    }
}

