/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.xss.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.sling.xss.impl.FallbackSlingPolicy;
import org.owasp.validator.html.AntiSamy;
import org.owasp.validator.html.Policy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyHandler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Policy policy;
    private Policy fallbackPolicy;
    private AntiSamy antiSamy;
    private AntiSamy fallbackAntiSamy;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PolicyHandler(InputStream policyStream) throws Exception {
        Thread currentThread = Thread.currentThread();
        ClassLoader cl = currentThread.getContextClassLoader();
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            currentThread.setContextClassLoader(this.getClass().getClassLoader());
            IOUtils.copy((InputStream)policyStream, (OutputStream)baos);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            currentThread.setContextClassLoader(this.getClass().getClassLoader());
            this.policy = Policy.getInstance(bais);
            if ("true".equals(this.policy.getDirective("embedStyleSheets"))) {
                this.logger.warn("The AntiSamy directive {} is set to true. This directive is deprecated and will not be supported in future Sling XSS bundle releases", (Object)"embedStyleSheets");
            }
            bais.reset();
            this.fallbackPolicy = new FallbackSlingPolicy(bais);
            this.antiSamy = new AntiSamy(this.policy);
            this.fallbackAntiSamy = new AntiSamy(this.fallbackPolicy);
        }
        finally {
            currentThread.setContextClassLoader(cl);
        }
    }

    public Policy getPolicy() {
        return this.policy;
    }

    public AntiSamy getAntiSamy() {
        return this.antiSamy;
    }

    public AntiSamy getFallbackAntiSamy() {
        return this.fallbackAntiSamy;
    }
}

