/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.common;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.math3.util.Pair;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.storm.common.CredentialKeyProvider;
import org.apache.storm.common.HadoopCredentialUtil;
import org.apache.storm.security.auth.IAutoCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHadoopAutoCreds
implements IAutoCredentials,
CredentialKeyProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractHadoopAutoCreds.class);
    private Set<String> configKeys = new HashSet<String>();

    public void prepare(Map<String, Object> topoConf) {
        this.doPrepare(topoConf);
        this.loadConfigKeys(topoConf);
    }

    public void populateCredentials(Map<String, String> credentials) {
        credentials.put(this.getCredentialKey(""), DatatypeConverter.printBase64Binary((byte[])"dummy place holder".getBytes()));
    }

    public void populateSubject(Subject subject, Map<String, String> credentials) {
        this.addCredentialToSubject(subject, credentials);
        this.addTokensToUGI(subject);
    }

    public void updateSubject(Subject subject, Map<String, String> credentials) {
        this.addCredentialToSubject(subject, credentials);
        this.addTokensToUGI(subject);
    }

    public Set<Pair<String, Credentials>> getCredentials(Map<String, String> credentials) {
        return HadoopCredentialUtil.getCredential(this, credentials, this.configKeys);
    }

    protected abstract void doPrepare(Map<String, Object> var1);

    protected abstract String getConfigKeyString();

    private void addCredentialToSubject(Subject subject, Map<String, String> credentials) {
        try {
            for (Pair<String, Credentials> cred : this.getCredentials(credentials)) {
                subject.getPrivateCredentials().add(cred.getSecond());
                LOG.info("Credentials added to the subject.");
            }
        }
        catch (Exception e) {
            LOG.error("Failed to initialize and get UserGroupInformation.", (Throwable)e);
        }
    }

    private void addTokensToUGI(Subject subject) {
        Set<Credentials> privateCredentials;
        if (subject != null && (privateCredentials = subject.getPrivateCredentials(Credentials.class)) != null) {
            for (Credentials cred : privateCredentials) {
                Collection allTokens = cred.getAllTokens();
                if (allTokens == null) continue;
                for (Token token : allTokens) {
                    try {
                        if (token == null) {
                            LOG.debug("Ignoring null token");
                            continue;
                        }
                        LOG.debug("Current user: {}", (Object)UserGroupInformation.getCurrentUser());
                        LOG.debug("Token from Credentials : {}", (Object)token);
                        TokenIdentifier tokenId = token.decodeIdentifier();
                        if (tokenId != null) {
                            LOG.debug("Token identifier : {}", (Object)tokenId);
                            LOG.debug("Username in token identifier : {}", (Object)tokenId.getUser());
                        }
                        UserGroupInformation.getCurrentUser().addToken(token);
                        LOG.info("Added delegation tokens to UGI.");
                    }
                    catch (IOException e) {
                        LOG.error("Exception while trying to add tokens to ugi", (Throwable)e);
                    }
                }
            }
        }
    }

    private void loadConfigKeys(Map<String, Object> conf) {
        String configKeyString = this.getConfigKeyString();
        List keys = (List)conf.get(configKeyString);
        if (keys != null) {
            this.configKeys.addAll(keys);
        }
    }
}

