/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hdfs.security;

import java.util.HashMap;
import javax.security.auth.Subject;
import org.apache.storm.hdfs.security.AutoHDFS;
import org.apache.storm.hdfs.security.AutoHDFSNimbus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AutoHDFSCommand {
    private static final Logger LOG = LoggerFactory.getLogger(AutoHDFSCommand.class);

    private AutoHDFSCommand() {
    }

    public static void main(String[] args) throws Exception {
        HashMap<String, Object> conf = new HashMap<String, Object>();
        conf.put("hdfs.kerberos.principal", args[1]);
        conf.put("hdfs.keytab.file", args[2]);
        AutoHDFS autoHDFS = new AutoHDFS();
        autoHDFS.prepare(conf);
        AutoHDFSNimbus autoHDFSNimbus = new AutoHDFSNimbus();
        autoHDFSNimbus.prepare(conf);
        HashMap<String, String> creds = new HashMap<String, String>();
        autoHDFSNimbus.populateCredentials(creds, conf, args[0]);
        LOG.info("Got HDFS credentials", autoHDFS.getCredentials(creds));
        Subject s = new Subject();
        autoHDFS.populateSubject(s, creds);
        LOG.info("Got a Subject " + s);
        autoHDFSNimbus.renew(creds, conf, args[0]);
        LOG.info("renewed credentials", autoHDFS.getCredentials(creds));
    }
}

