/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hdfs.security;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.util.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.storm.common.AbstractHadoopNimbusPluginAutoCreds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoHDFSNimbus
extends AbstractHadoopNimbusPluginAutoCreds {
    private static final Logger LOG = LoggerFactory.getLogger(AutoHDFSNimbus.class);
    private String hdfsKeyTab;
    private String hdfsPrincipal;

    @Override
    public void doPrepare(Map<String, Object> conf) {
        if (conf.containsKey("hdfs.keytab.file") && conf.containsKey("hdfs.kerberos.principal")) {
            this.hdfsKeyTab = (String)conf.get("hdfs.keytab.file");
            this.hdfsPrincipal = (String)conf.get("hdfs.kerberos.principal");
        }
    }

    @Override
    protected String getConfigKeyString() {
        return "hdfsCredentialsConfigKeys";
    }

    public void shutdown() {
    }

    @Override
    protected byte[] getHadoopCredentials(Map<String, Object> conf, String configKey, String topologyOwnerPrincipal) {
        Configuration configuration = this.getHadoopConfiguration(conf, configKey);
        return this.getHadoopCredentials(conf, configuration, topologyOwnerPrincipal);
    }

    @Override
    protected byte[] getHadoopCredentials(Map<String, Object> conf, String topologyOwnerPrincipal) {
        return this.getHadoopCredentials(conf, new Configuration(), topologyOwnerPrincipal);
    }

    private Configuration getHadoopConfiguration(Map<String, Object> topoConf, String configKey) {
        Configuration configuration = new Configuration();
        this.fillHadoopConfiguration(topoConf, configKey, configuration);
        return configuration;
    }

    private byte[] getHadoopCredentials(Map<String, Object> conf, final Configuration configuration, final String topologySubmitterUser) {
        try {
            if (UserGroupInformation.isSecurityEnabled()) {
                this.login(configuration);
                final URI nameNodeURI = conf.containsKey("topology.hdfs.uri") ? new URI(conf.get("topology.hdfs.uri").toString()) : FileSystem.getDefaultUri((Configuration)configuration);
                UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
                final UserGroupInformation proxyUser = UserGroupInformation.createProxyUser((String)topologySubmitterUser, (UserGroupInformation)ugi);
                Credentials creds = (Credentials)proxyUser.doAs((PrivilegedAction)new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        try {
                            FileSystem fileSystem = FileSystem.get((URI)nameNodeURI, (Configuration)configuration);
                            Credentials credential = proxyUser.getCredentials();
                            if (configuration.get("hdfs.kerberos.principal") == null) {
                                configuration.set("hdfs.kerberos.principal", AutoHDFSNimbus.this.hdfsPrincipal);
                            }
                            fileSystem.addDelegationTokens(configuration.get("hdfs.kerberos.principal"), credential);
                            LOG.info("Delegation tokens acquired for user {}", (Object)topologySubmitterUser);
                            return credential;
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
                ByteArrayOutputStream bao = new ByteArrayOutputStream();
                ObjectOutputStream out = new ObjectOutputStream(bao);
                creds.write((DataOutput)out);
                out.flush();
                out.close();
                return bao.toByteArray();
            }
            throw new RuntimeException("Security is not enabled for HDFS");
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to get delegation tokens.", ex);
        }
    }

    @Override
    public void doRenew(Map<String, String> credentials, Map<String, Object> topologyConf, String topologyOwnerPrincipal) {
        List<String> confKeys = this.getConfigKeys(topologyConf);
        for (Pair<String, Credentials> cred : this.getCredentials(credentials, confKeys)) {
            try {
                Configuration configuration = this.getHadoopConfiguration(topologyConf, (String)cred.getFirst());
                Collection tokens = ((Credentials)cred.getSecond()).getAllTokens();
                if (tokens != null && !tokens.isEmpty()) {
                    for (Token token : tokens) {
                        this.login(configuration);
                        long expiration = token.renew(configuration);
                        LOG.info("HDFS delegation token renewed, new expiration time {}", (Object)expiration);
                    }
                    continue;
                }
                LOG.debug("No tokens found for credentials, skipping renewal.");
            }
            catch (Exception e) {
                LOG.warn("could not renew the credentials, one of the possible reason is tokens are beyond renewal period so attempting to get new tokens.", (Throwable)e);
                this.populateCredentials(credentials, topologyConf, topologyOwnerPrincipal);
            }
        }
    }

    private void login(Configuration configuration) throws IOException {
        if (configuration.get("hdfs.keytab.file") == null) {
            configuration.set("hdfs.keytab.file", this.hdfsKeyTab);
        }
        if (configuration.get("hdfs.kerberos.principal") == null) {
            configuration.set("hdfs.kerberos.principal", this.hdfsPrincipal);
        }
        SecurityUtil.login((Configuration)configuration, (String)"hdfs.keytab.file", (String)"hdfs.kerberos.principal");
        LOG.info("Logged into hdfs with principal {}", (Object)configuration.get("hdfs.kerberos.principal"));
    }

    @Override
    public String getCredentialKey(String configKey) {
        return "HDFS_CREDENTIALS" + configKey;
    }
}

