/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.coordination;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.storm.Constants;
import org.apache.storm.generated.GlobalStreamId;
import org.apache.storm.task.IOutputCollector;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.FailedException;
import org.apache.storm.topology.IRichBolt;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.tuple.Values;
import org.apache.storm.utils.TimeCacheMap;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoordinatedBolt
implements IRichBolt {
    public static final Logger LOG = LoggerFactory.getLogger(CoordinatedBolt.class);
    private Map<String, SourceArgs> _sourceArgs;
    private IdStreamSpec _idStreamSpec;
    private IRichBolt _delegate;
    private Integer _numSourceReports;
    private List<Integer> _countOutTasks = new ArrayList<Integer>();
    private OutputCollector _collector;
    private TimeCacheMap<Object, TrackingInfo> _tracked;

    public CoordinatedBolt(IRichBolt delegate) {
        this(delegate, null, null);
    }

    public CoordinatedBolt(IRichBolt delegate, String sourceComponent, SourceArgs sourceArgs, IdStreamSpec idStreamSpec) {
        this(delegate, CoordinatedBolt.singleSourceArgs(sourceComponent, sourceArgs), idStreamSpec);
    }

    public CoordinatedBolt(IRichBolt delegate, Map<String, SourceArgs> sourceArgs, IdStreamSpec idStreamSpec) {
        this._sourceArgs = sourceArgs;
        if (this._sourceArgs == null) {
            this._sourceArgs = new HashMap<String, SourceArgs>();
        }
        this._delegate = delegate;
        this._idStreamSpec = idStreamSpec;
    }

    private static Map<String, SourceArgs> singleSourceArgs(String sourceComponent, SourceArgs sourceArgs) {
        HashMap<String, SourceArgs> ret = new HashMap<String, SourceArgs>();
        ret.put(sourceComponent, sourceArgs);
        return ret;
    }

    @Override
    public void prepare(Map<String, Object> config, TopologyContext context, OutputCollector collector) {
        TimeoutItems callback = null;
        if (this._delegate instanceof TimeoutCallback) {
            callback = new TimeoutItems();
        }
        this._tracked = new TimeCacheMap<Object, TrackingInfo>(context.maxTopologyMessageTimeout(), callback);
        this._collector = collector;
        this._delegate.prepare(config, context, new OutputCollector(new CoordinatedOutputCollector(collector)));
        for (String string : ((Map)Utils.get(context.getThisTargets(), Constants.COORDINATED_STREAM_ID, new HashMap())).keySet()) {
            for (Integer task : context.getComponentTasks(string)) {
                this._countOutTasks.add(task);
            }
        }
        if (!this._sourceArgs.isEmpty()) {
            this._numSourceReports = 0;
            for (Map.Entry entry : this._sourceArgs.entrySet()) {
                if (((SourceArgs)entry.getValue()).singleCount) {
                    this._numSourceReports = this._numSourceReports + 1;
                    continue;
                }
                this._numSourceReports = this._numSourceReports + context.getComponentTasks((String)entry.getKey()).size();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkFinishId(Tuple tup, TupleType type) {
        Object id = tup.getValue(0);
        boolean failed = false;
        TimeCacheMap<Object, TrackingInfo> timeCacheMap = this._tracked;
        synchronized (timeCacheMap) {
            TrackingInfo track = this._tracked.get(id);
            try {
                if (track != null) {
                    boolean delayed = false;
                    if (this._idStreamSpec == null && type == TupleType.COORD || this._idStreamSpec != null && type == TupleType.ID) {
                        track.ackTuples.add(tup);
                        delayed = true;
                    }
                    if (track.failed) {
                        failed = true;
                        for (Tuple t : track.ackTuples) {
                            this._collector.fail(t);
                        }
                        this._tracked.remove(id);
                    } else if (track.receivedId && (this._sourceArgs.isEmpty() || track.reportCount == this._numSourceReports && track.expectedTupleCount == track.receivedTuples)) {
                        if (this._delegate instanceof FinishedCallback) {
                            ((FinishedCallback)((Object)this._delegate)).finishedId(id);
                        }
                        if (!this._sourceArgs.isEmpty() && type == TupleType.REGULAR) {
                            throw new IllegalStateException("Coordination condition met on a non-coordinating tuple. Should be impossible");
                        }
                        for (int task : this._countOutTasks) {
                            int numTuples = Utils.get(track.taskEmittedTuples, task, 0);
                            this._collector.emitDirect(task, Constants.COORDINATED_STREAM_ID, tup, (List<Object>)new Values(id, numTuples));
                        }
                        for (Tuple t : track.ackTuples) {
                            this._collector.ack(t);
                        }
                        track.finished = true;
                        this._tracked.remove(id);
                    }
                    if (!delayed && type != TupleType.REGULAR) {
                        if (track.failed) {
                            this._collector.fail(tup);
                        } else {
                            this._collector.ack(tup);
                        }
                    }
                } else if (type != TupleType.REGULAR) {
                    this._collector.fail(tup);
                }
            }
            catch (FailedException e) {
                LOG.error("Failed to finish batch", (Throwable)e);
                for (Tuple t : track.ackTuples) {
                    this._collector.fail(t);
                }
                this._tracked.remove(id);
                failed = true;
            }
        }
        return failed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Tuple tuple) {
        TrackingInfo track;
        Object id = tuple.getValue(0);
        TupleType type = this.getTupleType(tuple);
        TimeCacheMap<Object, TrackingInfo> timeCacheMap = this._tracked;
        synchronized (timeCacheMap) {
            track = this._tracked.get(id);
            if (track == null) {
                track = new TrackingInfo();
                if (this._idStreamSpec == null) {
                    track.receivedId = true;
                }
                this._tracked.put(id, track);
            }
        }
        if (type == TupleType.ID) {
            timeCacheMap = this._tracked;
            synchronized (timeCacheMap) {
                track.receivedId = true;
            }
            this.checkFinishId(tuple, type);
        } else if (type == TupleType.COORD) {
            int count = (Integer)tuple.getValue(1);
            TimeCacheMap<Object, TrackingInfo> timeCacheMap2 = this._tracked;
            synchronized (timeCacheMap2) {
                ++track.reportCount;
                track.expectedTupleCount += count;
            }
            this.checkFinishId(tuple, type);
        } else {
            timeCacheMap = this._tracked;
            synchronized (timeCacheMap) {
                this._delegate.execute(tuple);
            }
        }
    }

    @Override
    public void cleanup() {
        this._delegate.cleanup();
        this._tracked.cleanup();
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        this._delegate.declareOutputFields(declarer);
        declarer.declareStream(Constants.COORDINATED_STREAM_ID, true, new Fields("id", "count"));
    }

    @Override
    public Map<String, Object> getComponentConfiguration() {
        return this._delegate.getComponentConfiguration();
    }

    private TupleType getTupleType(Tuple tuple) {
        if (this._idStreamSpec != null && tuple.getSourceGlobalStreamId().equals(this._idStreamSpec._id)) {
            return TupleType.ID;
        }
        if (!this._sourceArgs.isEmpty() && tuple.getSourceStreamId().equals(Constants.COORDINATED_STREAM_ID)) {
            return TupleType.COORD;
        }
        return TupleType.REGULAR;
    }

    private class TimeoutItems
    implements TimeCacheMap.ExpiredCallback<Object, TrackingInfo> {
        private TimeoutItems() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void expire(Object id, TrackingInfo val) {
            TimeCacheMap timeCacheMap = CoordinatedBolt.this._tracked;
            synchronized (timeCacheMap) {
                val.failed = true;
                if (!val.finished) {
                    ((TimeoutCallback)((Object)CoordinatedBolt.this._delegate)).timeoutId(id);
                }
            }
        }
    }

    public class CoordinatedOutputCollector
    implements IOutputCollector {
        IOutputCollector _delegate;

        public CoordinatedOutputCollector(IOutputCollector delegate) {
            this._delegate = delegate;
        }

        @Override
        public List<Integer> emit(String stream, Collection<Tuple> anchors, List<Object> tuple) {
            List<Integer> tasks = this._delegate.emit(stream, anchors, tuple);
            this.updateTaskCounts(tuple.get(0), tasks);
            return tasks;
        }

        @Override
        public void emitDirect(int task, String stream, Collection<Tuple> anchors, List<Object> tuple) {
            this.updateTaskCounts(tuple.get(0), Arrays.asList(task));
            this._delegate.emitDirect(task, stream, anchors, tuple);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void ack(Tuple tuple) {
            Object id = tuple.getValue(0);
            TimeCacheMap timeCacheMap = CoordinatedBolt.this._tracked;
            synchronized (timeCacheMap) {
                TrackingInfo track = (TrackingInfo)CoordinatedBolt.this._tracked.get(id);
                if (track != null) {
                    ++track.receivedTuples;
                }
            }
            boolean failed = CoordinatedBolt.this.checkFinishId(tuple, TupleType.REGULAR);
            if (failed) {
                this._delegate.fail(tuple);
            } else {
                this._delegate.ack(tuple);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void fail(Tuple tuple) {
            Object id = tuple.getValue(0);
            TimeCacheMap timeCacheMap = CoordinatedBolt.this._tracked;
            synchronized (timeCacheMap) {
                TrackingInfo track = (TrackingInfo)CoordinatedBolt.this._tracked.get(id);
                if (track != null) {
                    track.failed = true;
                }
            }
            CoordinatedBolt.this.checkFinishId(tuple, TupleType.REGULAR);
            this._delegate.fail(tuple);
        }

        @Override
        public void flush() {
            this._delegate.flush();
        }

        @Override
        public void resetTimeout(Tuple tuple) {
            this._delegate.resetTimeout(tuple);
        }

        @Override
        public void reportError(Throwable error) {
            this._delegate.reportError(error);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateTaskCounts(Object id, List<Integer> tasks) {
            TimeCacheMap timeCacheMap = CoordinatedBolt.this._tracked;
            synchronized (timeCacheMap) {
                TrackingInfo track = (TrackingInfo)CoordinatedBolt.this._tracked.get(id);
                if (track != null) {
                    Map<Integer, Integer> taskEmittedTuples = track.taskEmittedTuples;
                    for (Integer task : tasks) {
                        int newCount = Utils.get(taskEmittedTuples, task, 0) + 1;
                        taskEmittedTuples.put(task, newCount);
                    }
                }
            }
        }
    }

    public static class IdStreamSpec
    implements Serializable {
        GlobalStreamId _id;

        protected IdStreamSpec(String component, String stream) {
            this._id = new GlobalStreamId(component, stream);
        }

        public static IdStreamSpec makeDetectSpec(String component, String stream) {
            return new IdStreamSpec(component, stream);
        }

        public GlobalStreamId getGlobalStreamId() {
            return this._id;
        }
    }

    public static class TrackingInfo {
        int reportCount = 0;
        int expectedTupleCount = 0;
        int receivedTuples = 0;
        boolean failed = false;
        Map<Integer, Integer> taskEmittedTuples = new HashMap<Integer, Integer>();
        boolean receivedId = false;
        boolean finished = false;
        List<Tuple> ackTuples = new ArrayList<Tuple>();

        public String toString() {
            return "reportCount: " + this.reportCount + "\nexpectedTupleCount: " + this.expectedTupleCount + "\nreceivedTuples: " + this.receivedTuples + "\nfailed: " + this.failed + "\n" + this.taskEmittedTuples.toString();
        }
    }

    public static class SourceArgs
    implements Serializable {
        public boolean singleCount;

        protected SourceArgs(boolean singleCount) {
            this.singleCount = singleCount;
        }

        public static SourceArgs single() {
            return new SourceArgs(true);
        }

        public static SourceArgs all() {
            return new SourceArgs(false);
        }

        public String toString() {
            return "<Single: " + this.singleCount + ">";
        }
    }

    public static interface TimeoutCallback {
        public void timeoutId(Object var1);
    }

    public static interface FinishedCallback {
        public void finishedId(Object var1);
    }

    static enum TupleType {
        REGULAR,
        ID,
        COORD;

    }
}

