/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.messaging.netty;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.storm.messaging.IConnection;
import org.apache.storm.messaging.IContext;
import org.apache.storm.messaging.netty.Client;
import org.apache.storm.messaging.netty.NettyRenameThreadFactory;
import org.apache.storm.messaging.netty.Server;
import org.apache.storm.shade.io.netty.channel.EventLoopGroup;
import org.apache.storm.shade.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.storm.shade.io.netty.util.HashedWheelTimer;
import org.apache.storm.utils.ObjectReader;

public class Context
implements IContext {
    private Map<String, Object> topoConf;
    private List<Server> serverConnections;
    private EventLoopGroup workerEventLoopGroup;
    private HashedWheelTimer clientScheduleService;

    @Override
    public void prepare(Map<String, Object> topoConf) {
        this.topoConf = topoConf;
        this.serverConnections = new ArrayList<Server>();
        int maxWorkers = ObjectReader.getInt(topoConf.get("storm.messaging.netty.client_worker_threads"));
        NettyRenameThreadFactory workerFactory = new NettyRenameThreadFactory("client-worker");
        this.workerEventLoopGroup = new NioEventLoopGroup(maxWorkers > 0 ? maxWorkers : 0, (ThreadFactory)workerFactory);
        this.clientScheduleService = new HashedWheelTimer((ThreadFactory)new NettyRenameThreadFactory("client-schedule-service"));
    }

    @Override
    public synchronized IConnection bind(String storm_id, int port) {
        Server server = new Server(this.topoConf, port);
        this.serverConnections.add(server);
        return server;
    }

    @Override
    public IConnection connect(String storm_id, String host, int port, AtomicBoolean[] remoteBpStatus) {
        return new Client(this.topoConf, remoteBpStatus, this.workerEventLoopGroup, this.clientScheduleService, host, port);
    }

    @Override
    public synchronized void term() {
        this.clientScheduleService.stop();
        for (Server conn : this.serverConnections) {
            conn.close();
        }
        this.serverConnections = null;
        this.workerEventLoopGroup.shutdownGracefully().awaitUninterruptibly();
    }
}

