/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.messaging.netty;

import org.apache.storm.messaging.netty.INettySerializable;
import org.apache.storm.shade.io.netty.buffer.ByteBuf;
import org.apache.storm.shade.io.netty.buffer.Unpooled;

public enum ControlMessage implements INettySerializable
{
    CLOSE_MESSAGE(-100),
    EOB_MESSAGE(-201),
    OK_RESPONSE(-200),
    FAILURE_RESPONSE(-400),
    SASL_TOKEN_MESSAGE_REQUEST(-202),
    SASL_COMPLETE_REQUEST(-203);

    private final short code;

    private ControlMessage(short code) {
        this.code = code;
    }

    public static ControlMessage mkMessage(short encoded) {
        for (ControlMessage cm : ControlMessage.values()) {
            if (encoded != cm.code) continue;
            return cm;
        }
        return null;
    }

    public static ControlMessage read(byte[] serial) {
        ByteBuf cm_buffer = Unpooled.wrappedBuffer((byte[])serial);
        try {
            ControlMessage controlMessage = ControlMessage.mkMessage(cm_buffer.getShort(0));
            return controlMessage;
        }
        finally {
            cm_buffer.release();
        }
    }

    @Override
    public int encodeLength() {
        return 2;
    }

    @Override
    public void write(ByteBuf buf) {
        buf.writeShort((int)this.code);
    }
}

