/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.messaging.netty;

import java.io.IOException;
import java.util.Map;
import org.apache.storm.messaging.netty.ControlMessage;
import org.apache.storm.messaging.netty.ISaslClient;
import org.apache.storm.messaging.netty.KerberosSaslNettyClient;
import org.apache.storm.messaging.netty.KerberosSaslNettyClientState;
import org.apache.storm.messaging.netty.SaslMessageToken;
import org.apache.storm.shade.io.netty.channel.Channel;
import org.apache.storm.shade.io.netty.channel.ChannelHandler;
import org.apache.storm.shade.io.netty.channel.ChannelHandlerContext;
import org.apache.storm.shade.io.netty.channel.ChannelInboundHandlerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosSaslClientHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(KerberosSaslClientHandler.class);
    private final long start_time;
    private final ISaslClient client;
    private final Map<String, Object> topoConf;
    private final String jaas_section;
    private final String host;

    public KerberosSaslClientHandler(ISaslClient client, Map<String, Object> topoConf, String jaas_section, String host) throws IOException {
        this.client = client;
        this.topoConf = topoConf;
        this.jaas_section = jaas_section;
        this.host = host;
        this.start_time = System.currentTimeMillis();
    }

    public void channelActive(ChannelHandlerContext ctx) {
        Channel channel = ctx.channel();
        LOG.info("Connection established from {} to {}", (Object)channel.localAddress(), (Object)channel.remoteAddress());
        try {
            KerberosSaslNettyClient saslNettyClient = (KerberosSaslNettyClient)channel.attr(KerberosSaslNettyClientState.KERBEROS_SASL_NETTY_CLIENT).get();
            if (saslNettyClient == null) {
                LOG.debug("Creating saslNettyClient now for channel: {}", (Object)channel);
                saslNettyClient = new KerberosSaslNettyClient(this.topoConf, this.jaas_section, this.host);
                channel.attr(KerberosSaslNettyClientState.KERBEROS_SASL_NETTY_CLIENT).set((Object)saslNettyClient);
            }
            LOG.debug("Going to initiate Kerberos negotiations.");
            byte[] initialChallenge = saslNettyClient.saslResponse(new SaslMessageToken(new byte[0]));
            LOG.debug("Sending initial challenge: {}", (Object)initialChallenge);
            channel.writeAndFlush((Object)new SaslMessageToken(initialChallenge), channel.voidPromise());
        }
        catch (Exception e) {
            LOG.error("Failed to authenticate with server due to error: ", (Throwable)e);
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object message) throws Exception {
        LOG.debug("send/recv time (ms): {}", (Object)(System.currentTimeMillis() - this.start_time));
        if (message instanceof ControlMessage) {
            this.handleControlMessage(ctx, (ControlMessage)message);
        } else if (message instanceof SaslMessageToken) {
            this.handleSaslMessageToken(ctx, (SaslMessageToken)message);
        } else {
            LOG.error("Unexpected message from server: {}", message);
        }
    }

    private KerberosSaslNettyClient getChannelSaslClient(Channel channel) throws Exception {
        KerberosSaslNettyClient saslNettyClient = (KerberosSaslNettyClient)channel.attr(KerberosSaslNettyClientState.KERBEROS_SASL_NETTY_CLIENT).get();
        if (saslNettyClient == null) {
            throw new Exception("saslNettyClient was unexpectedly null for channel:" + channel);
        }
        return saslNettyClient;
    }

    private void handleControlMessage(ChannelHandlerContext ctx, ControlMessage controlMessage) throws Exception {
        Channel channel = ctx.channel();
        KerberosSaslNettyClient saslNettyClient = this.getChannelSaslClient(channel);
        if (controlMessage == ControlMessage.SASL_COMPLETE_REQUEST) {
            LOG.debug("Server has sent us the SaslComplete message. Allowing normal work to proceed.");
            if (!saslNettyClient.isComplete()) {
                String errorMessage = "Server returned a Sasl-complete message, but as far as we can tell, we are not authenticated yet.";
                LOG.error(errorMessage);
                throw new Exception(errorMessage);
            }
            ctx.pipeline().remove((ChannelHandler)this);
            this.client.channelReady(channel);
            ctx.fireChannelRead((Object)controlMessage);
        } else {
            LOG.warn("Unexpected control message: {}", (Object)controlMessage);
        }
    }

    private void handleSaslMessageToken(ChannelHandlerContext ctx, SaslMessageToken saslMessageToken) throws Exception {
        Channel channel = ctx.channel();
        KerberosSaslNettyClient saslNettyClient = this.getChannelSaslClient(channel);
        LOG.debug("Responding to server's token of length: {}", (Object)saslMessageToken.getSaslToken().length);
        byte[] responseToServer = saslNettyClient.saslResponse(saslMessageToken);
        if (responseToServer == null) {
            LOG.debug("Response to server is null: authentication should now be complete.");
            if (!saslNettyClient.isComplete()) {
                LOG.warn("Generated a null response, but authentication is not complete.");
                throw new Exception("Our reponse to the server is null, but as far as we can tell, we are not authenticated yet.");
            }
            this.client.channelReady(channel);
        } else {
            LOG.debug("Response to server token has length: {}", (Object)responseToServer.length);
            SaslMessageToken saslResponse = new SaslMessageToken(responseToServer);
            channel.writeAndFlush((Object)saslResponse, channel.voidPromise());
        }
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        super.channelRegistered(ctx);
        LOG.debug("channelRegistered {}", (Object)ctx);
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        super.channelUnregistered(ctx);
        LOG.debug("channelUnregistered {}", (Object)ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        LOG.warn("{} exceptionCaught", (Object)ctx, (Object)cause);
        super.exceptionCaught(ctx, cause);
    }
}

