/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.messaging.netty;

import java.util.ArrayList;
import org.apache.storm.messaging.TaskMessage;
import org.apache.storm.messaging.netty.ControlMessage;
import org.apache.storm.messaging.netty.INettySerializable;
import org.apache.storm.shade.io.netty.buffer.ByteBuf;

class MessageBatch
implements INettySerializable {
    private final int buffer_size;
    private final ArrayList<TaskMessage> msgs;
    private int encoded_length;

    MessageBatch(int buffer_size) {
        this.buffer_size = buffer_size;
        this.msgs = new ArrayList();
        this.encoded_length = ControlMessage.EOB_MESSAGE.encodeLength();
    }

    void add(TaskMessage msg) {
        if (msg == null) {
            throw new RuntimeException("null object forbidden in message batch");
        }
        this.msgs.add(msg);
        this.encoded_length += this.msgEncodeLength(msg);
    }

    private int msgEncodeLength(TaskMessage taskMsg) {
        if (taskMsg == null) {
            return 0;
        }
        int size = 6;
        if (taskMsg.message() != null) {
            size += taskMsg.message().length;
        }
        return size;
    }

    boolean isFull() {
        return this.encoded_length >= this.buffer_size;
    }

    boolean isEmpty() {
        return this.msgs.isEmpty();
    }

    int size() {
        return this.msgs.size();
    }

    @Override
    public int encodeLength() {
        return this.encoded_length;
    }

    @Override
    public void write(ByteBuf dest) {
        for (TaskMessage msg : this.msgs) {
            this.writeTaskMessage(dest, msg);
        }
        ControlMessage.EOB_MESSAGE.write(dest);
    }

    private void writeTaskMessage(ByteBuf buf, TaskMessage message) {
        int task_id;
        int payload_len = 0;
        if (message.message() != null) {
            payload_len = message.message().length;
        }
        if ((task_id = message.task()) > Short.MAX_VALUE) {
            throw new RuntimeException("Task ID should not exceed 32767");
        }
        buf.writeShort((int)((short)task_id));
        buf.writeInt(payload_len);
        if (payload_len > 0) {
            buf.writeBytes(message.message());
        }
    }
}

