/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.messaging.netty;

import org.apache.storm.messaging.netty.INettySerializable;
import org.apache.storm.shade.io.netty.buffer.ByteBuf;
import org.apache.storm.shade.io.netty.buffer.Unpooled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslMessageToken
implements INettySerializable {
    public static final short IDENTIFIER = -500;
    private static final Logger LOG = LoggerFactory.getLogger(SaslMessageToken.class);
    private byte[] token;

    public SaslMessageToken() {
    }

    public SaslMessageToken(byte[] token) {
        this.token = token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SaslMessageToken read(byte[] serial) {
        ByteBuf sm_buffer = Unpooled.wrappedBuffer((byte[])serial);
        try {
            short identifier = sm_buffer.readShort();
            int payload_len = sm_buffer.readInt();
            if (identifier != -500) {
                SaslMessageToken saslMessageToken = null;
                return saslMessageToken;
            }
            byte[] token = new byte[payload_len];
            sm_buffer.readBytes(token, 0, payload_len);
            SaslMessageToken saslMessageToken = new SaslMessageToken(token);
            return saslMessageToken;
        }
        finally {
            sm_buffer.release();
        }
    }

    public byte[] getSaslToken() {
        return this.token;
    }

    public void setSaslToken(byte[] token) {
        this.token = token;
    }

    @Override
    public int encodeLength() {
        return 6 + this.token.length;
    }

    @Override
    public void write(ByteBuf dest) {
        int payload_len = 0;
        if (this.token != null) {
            payload_len = this.token.length;
        }
        dest.writeShort(-500);
        dest.writeInt(payload_len);
        if (payload_len > 0) {
            dest.writeBytes(this.token);
        }
    }
}

