/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.messaging.netty;

import java.io.IOException;
import java.net.ConnectException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.storm.messaging.TaskMessage;
import org.apache.storm.messaging.netty.BackPressureStatus;
import org.apache.storm.messaging.netty.Client;
import org.apache.storm.messaging.netty.ControlMessage;
import org.apache.storm.serialization.KryoValuesDeserializer;
import org.apache.storm.shade.io.netty.channel.ChannelHandlerContext;
import org.apache.storm.shade.io.netty.channel.ChannelInboundHandlerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StormClientHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(StormClientHandler.class);
    private final Client client;
    private final KryoValuesDeserializer _des;
    private final AtomicBoolean[] remoteBpStatus;

    StormClientHandler(Client client, AtomicBoolean[] remoteBpStatus, Map<String, Object> conf) {
        this.client = client;
        this.remoteBpStatus = remoteBpStatus;
        this._des = new KryoValuesDeserializer(conf);
    }

    public void channelRead(ChannelHandlerContext ctx, Object message) throws Exception {
        if (message instanceof ControlMessage) {
            ControlMessage msg = (ControlMessage)message;
            if (msg == ControlMessage.FAILURE_RESPONSE) {
                LOG.info("failure response:{}", (Object)msg);
            }
        } else if (message instanceof BackPressureStatus) {
            BackPressureStatus status = (BackPressureStatus)message;
            if (status.bpTasks != null) {
                for (Integer bpTask : status.bpTasks) {
                    try {
                        this.remoteBpStatus[bpTask].set(true);
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        LOG.error("BP index out of bounds {}", (Throwable)e);
                    }
                }
            }
            if (status.nonBpTasks != null) {
                for (Integer bpTask : status.nonBpTasks) {
                    try {
                        this.remoteBpStatus[bpTask].set(false);
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        LOG.error("BP index out of bounds {}", (Throwable)e);
                    }
                }
            }
            LOG.debug("Received BackPressure status update : {}", (Object)status);
        } else if (message instanceof List) {
            List list = (List)message;
            if (list.size() < 1) {
                throw new RuntimeException("Didn't see enough load metrics (" + this.client.getDstAddress() + ") " + list);
            }
            TaskMessage tm = (TaskMessage)list.get(list.size() - 1);
            if (tm.task() != -1) {
                throw new RuntimeException("Metrics messages are sent to the system task (" + this.client.getDstAddress() + ") " + tm);
            }
            List<Object> metrics = this._des.deserialize(tm.message());
            if (metrics.size() < 1) {
                throw new RuntimeException("No metrics data in the metrics message (" + this.client.getDstAddress() + ") " + metrics);
            }
            if (!(metrics.get(0) instanceof Map)) {
                throw new RuntimeException("The metrics did not have a map in the first slot (" + this.client.getDstAddress() + ") " + metrics);
            }
            this.client.setLoadMetrics((Map)metrics.get(0));
        } else {
            throw new RuntimeException("Don't know how to handle a message of type " + message + " (" + this.client.getDstAddress() + ")");
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (!(cause instanceof ConnectException)) {
            if (cause instanceof IOException) {
                LOG.info("Connection to {} failed: {}", (Object)this.client.getDstAddress(), (Object)cause.getMessage());
            } else {
                LOG.error("Connection to {} failed: {}", (Object)this.client.getDstAddress(), (Object)cause);
            }
        }
    }
}

