/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.messaging.netty;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.storm.messaging.netty.IServer;
import org.apache.storm.shade.io.netty.channel.Channel;
import org.apache.storm.shade.io.netty.channel.ChannelHandlerContext;
import org.apache.storm.shade.io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StormServerHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(StormServerHandler.class);
    private static final Set<Class<?>> ALLOWED_EXCEPTIONS = new HashSet<Class>(Arrays.asList(IOException.class));
    private final IServer server;
    private final AtomicInteger failure_count;

    public StormServerHandler(IServer server) {
        this.server = server;
        this.failure_count = new AtomicInteger(0);
    }

    public void channelActive(ChannelHandlerContext ctx) {
        this.server.channelActive(ctx.channel());
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg == null) {
            return;
        }
        Channel channel = ctx.channel();
        try {
            this.server.received(msg, channel.remoteAddress().toString(), channel);
        }
        catch (InterruptedException e) {
            LOG.info("failed to enqueue a request message", (Throwable)e);
            this.failure_count.incrementAndGet();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        try {
            LOG.error("server errors in handling the request", cause);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            Utils.handleUncaughtException(cause, ALLOWED_EXCEPTIONS);
            ctx.close();
        }
        catch (Error error) {
            LOG.info("Received error in netty thread.. terminating server...");
            Runtime.getRuntime().exit(1);
        }
    }
}

