/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.messaging.netty;

import java.util.Map;
import org.apache.storm.messaging.netty.BackPressureStatusEncoder;
import org.apache.storm.messaging.netty.MessageDecoder;
import org.apache.storm.messaging.netty.NettySerializableMessageEncoder;
import org.apache.storm.messaging.netty.SaslStormServerAuthorizeHandler;
import org.apache.storm.messaging.netty.SaslStormServerHandler;
import org.apache.storm.messaging.netty.Server;
import org.apache.storm.messaging.netty.StormServerHandler;
import org.apache.storm.serialization.KryoValuesDeserializer;
import org.apache.storm.serialization.KryoValuesSerializer;
import org.apache.storm.shade.io.netty.channel.Channel;
import org.apache.storm.shade.io.netty.channel.ChannelHandler;
import org.apache.storm.shade.io.netty.channel.ChannelInitializer;
import org.apache.storm.shade.io.netty.channel.ChannelPipeline;

class StormServerPipelineFactory
extends ChannelInitializer<Channel> {
    private final Map<String, Object> topoConf;
    private final Server server;

    StormServerPipelineFactory(Map<String, Object> topoConf, Server server) {
        this.topoConf = topoConf;
        this.server = server;
    }

    protected void initChannel(Channel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast("decoder", (ChannelHandler)new MessageDecoder(new KryoValuesDeserializer(this.topoConf)));
        pipeline.addLast("netty-serializable-encoder", (ChannelHandler)NettySerializableMessageEncoder.INSTANCE);
        pipeline.addLast("backpressure-encoder", (ChannelHandler)new BackPressureStatusEncoder(new KryoValuesSerializer(this.topoConf)));
        boolean isNettyAuth = (Boolean)this.topoConf.get("storm.messaging.netty.authentication");
        if (isNettyAuth) {
            pipeline.addLast("saslServerHandler", (ChannelHandler)new SaslStormServerHandler(this.server));
            pipeline.addLast("authorizeServerHandler", (ChannelHandler)new SaslStormServerAuthorizeHandler());
        }
        pipeline.addLast("handler", (ChannelHandler)new StormServerHandler(this.server));
    }
}

