/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metric.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.TimerTask;
import org.apache.storm.metric.api.IMetric;
import org.apache.storm.metric.internal.MetricStatTimer;
import org.apache.storm.utils.Utils;

public class LatencyStatAndMetric
implements IMetric {
    private final Object _currentLock = new byte[0];
    private final int _tmSize;
    private final long[] _tmLatBuckets;
    private final long[] _tmCountBuckets;
    private final long[] _tmTime;
    private final int _thSize;
    private final long[] _thLatBuckets;
    private final long[] _thCountBuckets;
    private final long[] _thTime;
    private final int _odSize;
    private final long[] _odLatBuckets;
    private final long[] _odCountBuckets;
    private final long[] _odTime;
    private final TimerTask _task;
    private long _currentLatBucket;
    private long _currentCountBucket;
    private long _bucketStart;
    private long _exactExtraLat;
    private long _exactExtraCount;
    private long _allTimeLat;
    private long _allTimeCount;

    public LatencyStatAndMetric(int numBuckets) {
        this(numBuckets, -1L);
    }

    LatencyStatAndMetric(int numBuckets, long startTime) {
        numBuckets = Math.max(numBuckets, 2);
        this._tmSize = 600000 / (numBuckets - 1);
        this._thSize = 10800000 / (numBuckets - 1);
        this._odSize = 86400000 / (numBuckets - 1);
        if (this._tmSize < 1 || this._thSize < 1 || this._odSize < 1) {
            throw new IllegalArgumentException("number of buckets is too large to be supported");
        }
        this._tmLatBuckets = new long[numBuckets];
        this._tmCountBuckets = new long[numBuckets];
        this._tmTime = new long[numBuckets];
        this._thLatBuckets = new long[numBuckets];
        this._thCountBuckets = new long[numBuckets];
        this._thTime = new long[numBuckets];
        this._odLatBuckets = new long[numBuckets];
        this._odCountBuckets = new long[numBuckets];
        this._odTime = new long[numBuckets];
        this._allTimeLat = 0L;
        this._allTimeCount = 0L;
        this._exactExtraLat = 0L;
        this._exactExtraCount = 0L;
        this._bucketStart = startTime >= 0L ? startTime : System.currentTimeMillis();
        this._currentLatBucket = 0L;
        this._currentCountBucket = 0L;
        if (startTime < 0L) {
            this._task = new Fresher();
            MetricStatTimer._timer.scheduleAtFixedRate(this._task, this._tmSize, (long)this._tmSize);
        } else {
            this._task = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void record(long latency) {
        Object object = this._currentLock;
        synchronized (object) {
            this._currentLatBucket += latency;
            ++this._currentCountBucket;
        }
    }

    @Override
    public synchronized Object getValueAndReset() {
        return this.getValueAndReset(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized Object getValueAndReset(long now) {
        long count;
        long lat;
        Object object = this._currentLock;
        synchronized (object) {
            lat = this._currentLatBucket;
            count = this._currentCountBucket;
            this._currentLatBucket = 0L;
            this._currentCountBucket = 0L;
        }
        long timeSpent = now - this._bucketStart;
        long exactExtraCountSum = count + this._exactExtraCount;
        double ret = Utils.zeroIfNaNOrInf((double)(lat + this._exactExtraLat) / (double)exactExtraCountSum);
        this._bucketStart = now;
        this._exactExtraLat = 0L;
        this._exactExtraCount = 0L;
        this.rotateBuckets(lat, count, timeSpent);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void rotateSched(long now) {
        long count;
        long lat;
        Object object = this._currentLock;
        synchronized (object) {
            lat = this._currentLatBucket;
            count = this._currentCountBucket;
            this._currentLatBucket = 0L;
            this._currentCountBucket = 0L;
        }
        long timeSpent = now - this._bucketStart;
        this._exactExtraLat += lat;
        this._exactExtraCount += count;
        this._bucketStart = now;
        this.rotateBuckets(lat, count, timeSpent);
    }

    synchronized void rotateBuckets(long lat, long count, long timeSpent) {
        this.rotate(lat, count, timeSpent, this._tmSize, this._tmTime, this._tmLatBuckets, this._tmCountBuckets);
        this.rotate(lat, count, timeSpent, this._thSize, this._thTime, this._thLatBuckets, this._thCountBuckets);
        this.rotate(lat, count, timeSpent, this._odSize, this._odTime, this._odLatBuckets, this._odCountBuckets);
        this._allTimeLat += lat;
        this._allTimeCount += count;
    }

    private synchronized void rotate(long lat, long count, long timeSpent, long targetSize, long[] times, long[] latBuckets, long[] countBuckets) {
        times[0] = times[0] + timeSpent;
        latBuckets[0] = latBuckets[0] + lat;
        countBuckets[0] = countBuckets[0] + count;
        long currentTime = 0L;
        long currentLat = 0L;
        long currentCount = 0L;
        if (times[0] >= targetSize) {
            for (int i = 0; i < latBuckets.length; ++i) {
                long tmpTime = times[i];
                times[i] = currentTime;
                currentTime = tmpTime;
                long lt = latBuckets[i];
                latBuckets[i] = currentLat;
                currentLat = lt;
                long cnt = countBuckets[i];
                countBuckets[i] = currentCount;
                currentCount = cnt;
            }
        }
    }

    public synchronized Map<String, Double> getTimeLatAvg() {
        return this.getTimeLatAvg(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized Map<String, Double> getTimeLatAvg(long now) {
        long count;
        long lat;
        HashMap<String, Double> ret = new HashMap<String, Double>();
        Object object = this._currentLock;
        synchronized (object) {
            lat = this._currentLatBucket;
            count = this._currentCountBucket;
        }
        long timeSpent = now - this._bucketStart;
        ret.put("600", this.readApproximateLatAvg(lat, count, timeSpent, this._tmTime, this._tmLatBuckets, this._tmCountBuckets, 600000L));
        ret.put("10800", this.readApproximateLatAvg(lat, count, timeSpent, this._thTime, this._thLatBuckets, this._thCountBuckets, 10800000L));
        ret.put("86400", this.readApproximateLatAvg(lat, count, timeSpent, this._odTime, this._odLatBuckets, this._odCountBuckets, 86400000L));
        long allTimeCountSum = count + this._allTimeCount;
        ret.put(":all-time", Utils.zeroIfNaNOrInf((double)lat + (double)this._allTimeLat) / (double)allTimeCountSum);
        return ret;
    }

    double readApproximateLatAvg(long lat, long count, long timeSpent, long[] bucketTime, long[] latBuckets, long[] countBuckets, long desiredTime) {
        long timeNeeded = desiredTime - timeSpent;
        long totalLat = lat;
        long totalCount = count;
        for (int i = 0; i < bucketTime.length && timeNeeded > 0L; timeNeeded -= bucketTime[i], ++i) {
            totalLat += latBuckets[i];
            totalCount += countBuckets[i];
        }
        return Utils.zeroIfNaNOrInf((double)totalLat / (double)totalCount);
    }

    public void close() {
        if (this._task != null) {
            this._task.cancel();
        }
    }

    private class Fresher
    extends TimerTask {
        private Fresher() {
        }

        @Override
        public void run() {
            LatencyStatAndMetric.this.rotateSched(System.currentTimeMillis());
        }
    }
}

