/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metric.internal;

import java.io.Closeable;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.storm.metric.internal.MetricStatTimer;

public class RateTracker
implements Closeable {
    private final int _bucketSizeMillis;
    private final long[] _bucketTime;
    private final long[] _oldBuckets;
    private final AtomicLong _bucketStart;
    private final AtomicLong _currentBucket;
    private final TimerTask _task;

    public RateTracker(int validTimeWindowInMils, int numBuckets) {
        this(validTimeWindowInMils, numBuckets, -1L);
    }

    RateTracker(int validTimeWindowInMils, int numBuckets, long startTime) {
        numBuckets = Math.max(numBuckets, 1);
        this._bucketSizeMillis = validTimeWindowInMils / numBuckets;
        if (this._bucketSizeMillis < 1) {
            throw new IllegalArgumentException("validTimeWindowInMilis and numOfSildes cause each slide to have a window that is too small");
        }
        this._bucketTime = new long[numBuckets - 1];
        this._oldBuckets = new long[numBuckets - 1];
        this._bucketStart = new AtomicLong(startTime >= 0L ? startTime : System.currentTimeMillis());
        this._currentBucket = new AtomicLong(0L);
        if (startTime < 0L) {
            this._task = new Fresher();
            MetricStatTimer._timer.scheduleAtFixedRate(this._task, this._bucketSizeMillis, (long)this._bucketSizeMillis);
        } else {
            this._task = null;
        }
    }

    public void notify(long count) {
        this._currentBucket.addAndGet(count);
    }

    public synchronized double reportRate() {
        return this.reportRate(System.currentTimeMillis());
    }

    synchronized double reportRate(long currentTime) {
        long duration = Math.max(1L, currentTime - this._bucketStart.get());
        long events = this._currentBucket.get();
        for (int i = 0; i < this._oldBuckets.length; ++i) {
            events += this._oldBuckets[i];
            duration += this._bucketTime[i];
        }
        return (double)events * 1000.0 / (double)duration;
    }

    @Override
    public void close() {
        if (this._task != null) {
            this._task.cancel();
        }
    }

    final void forceRotate(int numToEclipse, long interval) {
        long time = this._bucketStart.get();
        for (int i = 0; i < numToEclipse; ++i) {
            this.rotateBuckets(time += interval);
        }
    }

    private synchronized void rotateBuckets(long time) {
        long timeSpent = time - this._bucketStart.getAndSet(time);
        long currentVal = this._currentBucket.getAndSet(0L);
        for (int i = 0; i < this._oldBuckets.length; ++i) {
            long tmpTime = this._bucketTime[i];
            this._bucketTime[i] = timeSpent;
            timeSpent = tmpTime;
            long cnt = this._oldBuckets[i];
            this._oldBuckets[i] = currentVal;
            currentVal = cnt;
        }
    }

    private class Fresher
    extends TimerTask {
        private Fresher() {
        }

        @Override
        public void run() {
            RateTracker.this.rotateBuckets(System.currentTimeMillis());
        }
    }
}

