/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metrics2;

import com.codahale.metrics.Counter;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.storm.metrics2.StormMetricRegistry;
import org.apache.storm.task.WorkerTopologyContext;

public class TaskMetrics {
    private static final String METRIC_NAME_ACKED = "acked";
    private static final String METRIC_NAME_FAILED = "failed";
    private static final String METRIC_NAME_EMITTED = "emitted";
    private static final String METRIC_NAME_TRANSFERRED = "transferred";
    private ConcurrentMap<String, Counter> ackedByStream = new ConcurrentHashMap<String, Counter>();
    private ConcurrentMap<String, Counter> failedByStream = new ConcurrentHashMap<String, Counter>();
    private ConcurrentMap<String, Counter> emittedByStream = new ConcurrentHashMap<String, Counter>();
    private ConcurrentMap<String, Counter> transferredByStream = new ConcurrentHashMap<String, Counter>();
    private String topologyId;
    private String componentId;
    private Integer taskId;
    private Integer workerPort;

    public TaskMetrics(WorkerTopologyContext context, String componentId, Integer taskid) {
        this.topologyId = context.getStormId();
        this.componentId = componentId;
        this.taskId = taskid;
        this.workerPort = context.getThisWorkerPort();
    }

    public Counter getAcked(String streamId) {
        Counter c = (Counter)this.ackedByStream.get(streamId);
        if (c == null) {
            c = StormMetricRegistry.counter(METRIC_NAME_ACKED, this.topologyId, this.componentId, this.taskId, this.workerPort, streamId);
            this.ackedByStream.put(streamId, c);
        }
        return c;
    }

    public Counter getFailed(String streamId) {
        Counter c = (Counter)this.failedByStream.get(streamId);
        if (c == null) {
            c = StormMetricRegistry.counter(METRIC_NAME_FAILED, this.topologyId, this.componentId, this.taskId, this.workerPort, streamId);
            this.failedByStream.put(streamId, c);
        }
        return c;
    }

    public Counter getEmitted(String streamId) {
        Counter c = (Counter)this.emittedByStream.get(streamId);
        if (c == null) {
            c = StormMetricRegistry.counter(METRIC_NAME_EMITTED, this.topologyId, this.componentId, this.taskId, this.workerPort, streamId);
            this.emittedByStream.put(streamId, c);
        }
        return c;
    }

    public Counter getTransferred(String streamId) {
        Counter c = (Counter)this.transferredByStream.get(streamId);
        if (c == null) {
            c = StormMetricRegistry.counter(METRIC_NAME_TRANSFERRED, this.topologyId, this.componentId, this.taskId, this.workerPort, streamId);
            this.transferredByStream.put(streamId, c);
        }
        return c;
    }
}

