/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.pacemaker;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.login.Configuration;
import org.apache.storm.generated.HBMessage;
import org.apache.storm.messaging.netty.ISaslClient;
import org.apache.storm.messaging.netty.NettyRenameThreadFactory;
import org.apache.storm.pacemaker.PacemakerConnectionException;
import org.apache.storm.pacemaker.codec.ThriftNettyClientCodec;
import org.apache.storm.security.auth.ClientAuthUtils;
import org.apache.storm.shade.io.netty.bootstrap.Bootstrap;
import org.apache.storm.shade.io.netty.buffer.PooledByteBufAllocator;
import org.apache.storm.shade.io.netty.channel.Channel;
import org.apache.storm.shade.io.netty.channel.ChannelHandler;
import org.apache.storm.shade.io.netty.channel.ChannelOption;
import org.apache.storm.shade.io.netty.channel.EventLoopGroup;
import org.apache.storm.shade.io.netty.channel.WriteBufferWaterMark;
import org.apache.storm.shade.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.storm.shade.io.netty.channel.socket.nio.NioSocketChannel;
import org.apache.storm.utils.StormBoundedExponentialBackoffRetry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PacemakerClient
implements ISaslClient {
    private static final Logger LOG = LoggerFactory.getLogger(PacemakerClient.class);
    private static Timer timer = new Timer(true);
    private final Bootstrap bootstrap;
    private final EventLoopGroup workerEventLoopGroup;
    private String client_name;
    private String secret;
    private AtomicBoolean ready;
    private AtomicBoolean shutdown;
    private AtomicReference<Channel> channelRef;
    private InetSocketAddress remote_addr;
    private int maxPending = 100;
    private HBMessage[] messages;
    private LinkedBlockingQueue<Integer> availableMessageSlots;
    private ThriftNettyClientCodec.AuthMethod authMethod;
    private static final int maxRetries = 10;
    private String host;
    private StormBoundedExponentialBackoffRetry backoff = new StormBoundedExponentialBackoffRetry(100, 5000, 20);
    private int retryTimes = 0;

    public PacemakerClient(Map<String, Object> config, String host) {
        String auth;
        this.host = host;
        int port = (Integer)config.get("pacemaker.port");
        this.client_name = (String)config.get("topology.name");
        if (this.client_name == null) {
            this.client_name = "pacemaker-client";
        }
        int maxWorkers = (Integer)config.get("pacemaker.client.max.threads");
        switch (auth = (String)config.get("pacemaker.auth.method")) {
            case "DIGEST": {
                Configuration login_conf = ClientAuthUtils.getConfiguration(config);
                this.authMethod = ThriftNettyClientCodec.AuthMethod.DIGEST;
                this.secret = ClientAuthUtils.makeDigestPayload(login_conf, "PacemakerDigest");
                if (this.secret != null) break;
                LOG.error("Can't start pacemaker server without digest secret.");
                throw new RuntimeException("Can't start pacemaker server without digest secret.");
            }
            case "KERBEROS": {
                this.authMethod = ThriftNettyClientCodec.AuthMethod.KERBEROS;
                break;
            }
            case "NONE": {
                this.authMethod = ThriftNettyClientCodec.AuthMethod.NONE;
                break;
            }
            default: {
                this.authMethod = ThriftNettyClientCodec.AuthMethod.NONE;
                LOG.warn("Invalid auth scheme: '{}'. Falling back to 'NONE'", (Object)auth);
            }
        }
        this.ready = new AtomicBoolean(false);
        this.shutdown = new AtomicBoolean(false);
        this.channelRef = new AtomicReference<Object>(null);
        this.setupMessaging();
        NettyRenameThreadFactory workerFactory = new NettyRenameThreadFactory(this.host + "-pm");
        this.workerEventLoopGroup = new NioEventLoopGroup(maxWorkers > 0 ? maxWorkers : 0, (ThreadFactory)workerFactory);
        int thriftMessageMaxSize = (Integer)config.get("pacemaker.thrift.message.size.max");
        this.bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.workerEventLoopGroup)).channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_SNDBUF, (Object)0x500000)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(8192, 32768))).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).handler((ChannelHandler)new ThriftNettyClientCodec(this, config, this.authMethod, host, thriftMessageMaxSize));
        this.remote_addr = new InetSocketAddress(host, port);
        this.bootstrap.connect((SocketAddress)this.remote_addr);
    }

    private void setupMessaging() {
        this.messages = new HBMessage[this.maxPending];
        this.availableMessageSlots = new LinkedBlockingQueue();
        for (int i = 0; i < this.maxPending; ++i) {
            this.availableMessageSlots.add(i);
        }
    }

    @Override
    public synchronized void channelReady(Channel channel) {
        Channel oldChannel = this.channelRef.get();
        if (oldChannel != null) {
            LOG.debug("Closing oldChannel is connected: {}", (Object)oldChannel.toString());
            this.close_channel();
        }
        this.channelRef.set(channel);
        this.retryTimes = 0;
        LOG.debug("Channel is ready: {}", (Object)channel.toString());
        this.ready.set(true);
        this.notifyAll();
    }

    @Override
    public String name() {
        return this.client_name;
    }

    @Override
    public String secretKey() {
        return this.secret;
    }

    public HBMessage send(HBMessage m) throws PacemakerConnectionException, InterruptedException {
        LOG.debug("Sending pacemaker message to {}: {}", (Object)this.host, (Object)m);
        int next = this.availableMessageSlots.take();
        HBMessage hBMessage = m;
        synchronized (hBMessage) {
            m.set_message_id(next);
            this.messages[next] = m;
            LOG.debug("Put message in slot: {} for {}", (Object)Integer.toString(next), (Object)this.host);
            int retry = 10;
            while (true) {
                try {
                    this.waitUntilReady();
                    Channel channel = this.channelRef.get();
                    if (channel != null) {
                        channel.writeAndFlush((Object)m, channel.voidPromise());
                        m.wait(1000L);
                    }
                    if (this.messages[next] != m && this.messages[next] != null) {
                        HBMessage ret = this.messages[next];
                        this.messages[next] = null;
                        LOG.debug("Got Response: {}", (Object)ret);
                        return ret;
                    }
                }
                catch (PacemakerConnectionException e) {
                    if (retry <= 0) {
                        throw e;
                    }
                    LOG.error("error attempting to write to a channel {}.", (Object)e.getMessage());
                }
                if (retry <= 0) {
                    throw new PacemakerConnectionException("couldn't get response after 10 attempts.");
                }
                LOG.warn("Not getting response or getting null response. Making {} more attempts for {}.", (Object)(--retry), (Object)this.host);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntilReady() throws PacemakerConnectionException, InterruptedException {
        if (!this.ready.get() || this.channelRef.get() == null) {
            PacemakerClient pacemakerClient = this;
            synchronized (pacemakerClient) {
                if (!this.ready.get()) {
                    LOG.debug("Waiting for netty channel to be ready.");
                    this.wait(1000L);
                    if (!this.ready.get() || this.channelRef.get() == null) {
                        throw new PacemakerConnectionException("Timed out waiting for channel ready.");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gotMessage(HBMessage m) {
        int message_id = m.get_message_id();
        if (message_id >= 0 && message_id < this.maxPending) {
            LOG.debug("Pacemaker client got message: {}", (Object)m.toString());
            HBMessage request = this.messages[message_id];
            if (request == null) {
                LOG.debug("No message for slot: {}", (Object)Integer.toString(message_id));
            } else {
                HBMessage hBMessage = request;
                synchronized (hBMessage) {
                    this.messages[message_id] = m;
                    request.notifyAll();
                    this.availableMessageSlots.add(message_id);
                }
            }
        } else {
            LOG.error("Got Message with bad id: {}", (Object)m.toString());
        }
    }

    public void reconnect() {
        final PacemakerClient client = this;
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                client.doReconnect();
            }
        }, this.backoff.getSleepTimeMs(this.retryTimes++, 0L));
        this.ready.set(false);
        this.setupMessaging();
    }

    public synchronized void doReconnect() {
        LOG.info("reconnecting to {}", (Object)this.host);
        this.close_channel();
        if (!this.shutdown.get()) {
            this.bootstrap.connect((SocketAddress)this.remote_addr);
        }
    }

    public void shutdown() {
        this.shutdown.set(true);
        this.workerEventLoopGroup.shutdownGracefully().awaitUninterruptibly();
    }

    private synchronized void close_channel() {
        if (this.channelRef.get() != null) {
            this.channelRef.get().close();
            LOG.debug("channel {} closed", (Object)this.remote_addr);
            this.channelRef.set(null);
        }
    }

    public void close() {
        this.close_channel();
    }
}

