/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.pacemaker.codec;

import java.util.List;
import org.apache.storm.generated.HBMessage;
import org.apache.storm.generated.HBMessageData;
import org.apache.storm.generated.HBServerMessageType;
import org.apache.storm.messaging.netty.ControlMessage;
import org.apache.storm.messaging.netty.INettySerializable;
import org.apache.storm.messaging.netty.SaslMessageToken;
import org.apache.storm.shade.io.netty.buffer.ByteBuf;
import org.apache.storm.shade.io.netty.buffer.ByteBufAllocator;
import org.apache.storm.shade.io.netty.buffer.Unpooled;
import org.apache.storm.shade.io.netty.channel.ChannelHandlerContext;
import org.apache.storm.shade.io.netty.handler.codec.MessageToMessageEncoder;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftEncoder
extends MessageToMessageEncoder<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(ThriftEncoder.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HBMessage encodeNettySerializable(ByteBufAllocator alloc, INettySerializable netty_message, HBServerMessageType mType) {
        HBMessageData message_data = new HBMessageData();
        HBMessage m = new HBMessage();
        byte[] messageBuffer = new byte[netty_message.encodeLength()];
        ByteBuf wrappedBuffer = Unpooled.wrappedBuffer((byte[])messageBuffer);
        try {
            wrappedBuffer.resetWriterIndex();
            netty_message.write(wrappedBuffer);
            message_data.set_message_blob(messageBuffer);
            m.set_type(mType);
            m.set_data(message_data);
            HBMessage hBMessage = m;
            return hBMessage;
        }
        finally {
            wrappedBuffer.release();
        }
    }

    protected void encode(ChannelHandlerContext channelHandlerContext, Object msg, List<Object> out) throws Exception {
        HBMessage m;
        if (msg == null) {
            return;
        }
        LOG.debug("Trying to encode: " + msg.getClass().toString() + " : " + msg.toString());
        ByteBufAllocator alloc = channelHandlerContext.alloc();
        if (msg instanceof INettySerializable) {
            HBServerMessageType type;
            INettySerializable nettyMsg = (INettySerializable)msg;
            if (msg instanceof ControlMessage) {
                type = HBServerMessageType.CONTROL_MESSAGE;
            } else if (msg instanceof SaslMessageToken) {
                type = HBServerMessageType.SASL_MESSAGE_TOKEN;
            } else {
                LOG.error("Didn't recognise INettySerializable: " + nettyMsg.toString());
                throw new RuntimeException("Unrecognized INettySerializable.");
            }
            m = this.encodeNettySerializable(alloc, nettyMsg, type);
        } else {
            m = (HBMessage)msg;
        }
        try {
            byte[] serialized = Utils.thriftSerialize(m);
            ByteBuf ret = alloc.ioBuffer(serialized.length + 4);
            ret.writeInt(serialized.length);
            ret.writeBytes(serialized);
            out.add(ret);
        }
        catch (RuntimeException e) {
            LOG.error("Failed to serialize.", (Throwable)e);
            throw e;
        }
    }
}

