/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.security.auth;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.URIParameter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.apache.storm.generated.WorkerToken;
import org.apache.storm.generated.WorkerTokenInfo;
import org.apache.storm.generated.WorkerTokenServiceType;
import org.apache.storm.security.INimbusCredentialPlugin;
import org.apache.storm.security.auth.IAutoCredentials;
import org.apache.storm.security.auth.ICredentialsRenewer;
import org.apache.storm.security.auth.IGroupMappingServiceProvider;
import org.apache.storm.security.auth.IPrincipalToLocal;
import org.apache.storm.security.auth.ITransportPlugin;
import org.apache.storm.security.auth.ThriftConnectionType;
import org.apache.storm.security.auth.ThriftServer;
import org.apache.storm.shade.org.apache.commons.codec.binary.Hex;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.ReflectionUtils;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientAuthUtils {
    public static final String LOGIN_CONTEXT_SERVER = "StormServer";
    public static final String LOGIN_CONTEXT_CLIENT = "StormClient";
    public static final String LOGIN_CONTEXT_PACEMAKER_DIGEST = "PacemakerDigest";
    public static final String LOGIN_CONTEXT_PACEMAKER_SERVER = "PacemakerServer";
    public static final String LOGIN_CONTEXT_PACEMAKER_CLIENT = "PacemakerClient";
    public static final String SERVICE = "storm_thrift_server";
    private static final Logger LOG = LoggerFactory.getLogger(ClientAuthUtils.class);
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";

    public static Configuration getConfiguration(Map<String, Object> topoConf) {
        Configuration login_conf = null;
        String loginConfigurationFile = (String)topoConf.get("java.security.auth.login.config");
        if (loginConfigurationFile != null && loginConfigurationFile.length() > 0) {
            File config_file = new File(loginConfigurationFile);
            if (!config_file.canRead()) {
                throw new RuntimeException("File " + loginConfigurationFile + " cannot be read.");
            }
            try {
                URI config_uri = config_file.toURI();
                login_conf = Configuration.getInstance("JavaLoginConfig", new URIParameter(config_uri));
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return login_conf;
    }

    public static AppConfigurationEntry[] getEntries(Configuration configuration, String section) throws IOException {
        if (configuration == null) {
            return null;
        }
        AppConfigurationEntry[] configurationEntries = configuration.getAppConfigurationEntry(section);
        if (configurationEntries == null) {
            String errorMessage = "Could not find a '" + section + "' entry in this configuration.";
            throw new IOException(errorMessage);
        }
        return configurationEntries;
    }

    public static SortedMap<String, ?> pullConfig(Configuration configuration, String section) throws IOException {
        AppConfigurationEntry[] configurationEntries = ClientAuthUtils.getEntries(configuration, section);
        if (configurationEntries == null) {
            return null;
        }
        TreeMap results = new TreeMap();
        for (AppConfigurationEntry entry : configurationEntries) {
            Map<String, ?> options = entry.getOptions();
            for (String key : options.keySet()) {
                results.put(key, options.get(key));
            }
        }
        return results;
    }

    public static String get(Configuration configuration, String section, String key) throws IOException {
        AppConfigurationEntry[] configurationEntries = ClientAuthUtils.getEntries(configuration, section);
        if (configurationEntries == null) {
            return null;
        }
        for (AppConfigurationEntry entry : configurationEntries) {
            Object val = entry.getOptions().get(key);
            if (val == null) continue;
            return (String)val;
        }
        return null;
    }

    public static IPrincipalToLocal getPrincipalToLocalPlugin(Map<String, Object> topoConf) {
        IPrincipalToLocal ptol = null;
        try {
            String ptol_klassName = (String)topoConf.get("storm.principal.tolocal");
            if (ptol_klassName == null) {
                LOG.warn("No principal to local given {}", (Object)"storm.principal.tolocal");
            } else {
                ptol = (IPrincipalToLocal)ReflectionUtils.newInstance(ptol_klassName);
                if (ptol != null) {
                    ptol.prepare(topoConf);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return ptol;
    }

    public static IGroupMappingServiceProvider getGroupMappingServiceProviderPlugin(Map<String, Object> conf) {
        IGroupMappingServiceProvider gmsp = null;
        try {
            String gmsp_klassName = (String)conf.get("storm.group.mapping.service");
            if (gmsp_klassName == null) {
                LOG.warn("No group mapper given {}", (Object)"storm.group.mapping.service");
            } else {
                gmsp = (IGroupMappingServiceProvider)ReflectionUtils.newInstance(gmsp_klassName);
                if (gmsp != null) {
                    gmsp.prepare(conf);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return gmsp;
    }

    public static Collection<ICredentialsRenewer> getCredentialRenewers(Map<String, Object> conf) {
        try {
            HashSet<ICredentialsRenewer> ret = new HashSet<ICredentialsRenewer>();
            Collection clazzes = (Collection)conf.get("nimbus.credential.renewers.classes");
            if (clazzes != null) {
                for (String clazz : clazzes) {
                    ICredentialsRenewer inst = (ICredentialsRenewer)ReflectionUtils.newInstance(clazz);
                    inst.prepare(conf);
                    ret.add(inst);
                }
            }
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Collection<INimbusCredentialPlugin> getNimbusAutoCredPlugins(Map<String, Object> conf) {
        try {
            HashSet<INimbusCredentialPlugin> ret = new HashSet<INimbusCredentialPlugin>();
            Collection clazzes = (Collection)conf.get("nimbus.autocredential.plugins.classes");
            if (clazzes != null) {
                for (String clazz : clazzes) {
                    INimbusCredentialPlugin inst = (INimbusCredentialPlugin)ReflectionUtils.newInstance(clazz);
                    inst.prepare(conf);
                    ret.add(inst);
                }
            }
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Collection<IAutoCredentials> getAutoCredentials(Map<String, Object> topoConf) {
        try {
            HashSet<IAutoCredentials> autos = new HashSet<IAutoCredentials>();
            Collection clazzes = (Collection)topoConf.get("topology.auto-credentials");
            if (clazzes != null) {
                for (String clazz : clazzes) {
                    IAutoCredentials a = (IAutoCredentials)ReflectionUtils.newInstance(clazz);
                    a.prepare(topoConf);
                    autos.add(a);
                }
            }
            LOG.info("Got AutoCreds " + autos);
            return autos;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String workerTokenCredentialsKey(WorkerTokenServiceType type) {
        return "STORM_WORKER_TOKEN_" + type.name();
    }

    public static WorkerToken readWorkerToken(Map<String, String> credentials, WorkerTokenServiceType type) {
        WorkerToken ret = null;
        String key = ClientAuthUtils.workerTokenCredentialsKey(type);
        String tokenStr = credentials.get(key);
        if (tokenStr != null) {
            ret = Utils.deserializeFromString(tokenStr, WorkerToken.class);
        }
        return ret;
    }

    public static void setWorkerToken(Map<String, String> credentials, WorkerToken token) {
        String key = ClientAuthUtils.workerTokenCredentialsKey(token.get_serviceType());
        credentials.put(key, Utils.serializeToString(token));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WorkerToken findWorkerToken(Subject subject, WorkerTokenServiceType type) {
        Set<WorkerToken> creds;
        Set<WorkerToken> set = creds = subject.getPrivateCredentials(WorkerToken.class);
        synchronized (set) {
            return creds.stream().filter(wt -> wt.get_serviceType() == type).findAny().orElse(null);
        }
    }

    private static boolean willWorkerTokensBeStoredSecurely(Map<String, Object> conf) {
        boolean overrideZkAuth = ObjectReader.getBoolean(conf.get("TESTING.ONLY.ENABLE.INSECURE.WORKER.TOKENS"), false);
        if (Utils.isZkAuthenticationConfiguredStormServer(conf)) {
            return true;
        }
        if (overrideZkAuth) {
            LOG.error("\n\n\t\tYOU HAVE ENABLED INSECURE WORKER TOKENS.  IF THIS IS NOT A UNIT TEST PLEASE STOP NOW!!!\n\n");
            return true;
        }
        return false;
    }

    public static boolean areWorkerTokensEnabledServer(ThriftServer server, Map<String, Object> conf) {
        return server.supportsWorkerTokens() && ClientAuthUtils.willWorkerTokensBeStoredSecurely(conf);
    }

    public static boolean areWorkerTokensEnabledServer(ThriftConnectionType connectionType, Map<String, Object> conf) {
        return connectionType.getWtType() != null && ClientAuthUtils.willWorkerTokensBeStoredSecurely(conf);
    }

    public static byte[] serializeWorkerTokenInfo(WorkerTokenInfo wti) {
        return Utils.serialize(wti);
    }

    public static WorkerTokenInfo getWorkerTokenInfo(WorkerToken wt) {
        return Utils.deserialize(wt.get_info(), WorkerTokenInfo.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Subject insertWorkerTokens(Subject subject, Map<String, String> credentials) {
        if (credentials == null) {
            return subject;
        }
        for (WorkerTokenServiceType type : WorkerTokenServiceType.values()) {
            Set<Object> creds;
            WorkerToken token = ClientAuthUtils.readWorkerToken(credentials, type);
            if (token == null) continue;
            Set<Object> set = creds = subject.getPrivateCredentials();
            synchronized (set) {
                WorkerToken previous = ClientAuthUtils.findWorkerToken(subject, type);
                creds.add(token);
                if (previous != null) {
                    creds.remove(previous);
                }
            }
        }
        return subject;
    }

    public static Subject populateSubject(Subject subject, Collection<IAutoCredentials> autos, Map<String, String> credentials) {
        try {
            if (subject == null) {
                subject = new Subject();
            }
            for (IAutoCredentials autoCred : autos) {
                autoCred.populateSubject(subject, credentials);
            }
            return ClientAuthUtils.insertWorkerTokens(subject, credentials);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void updateSubject(Subject subject, Collection<IAutoCredentials> autos, Map<String, String> credentials) {
        if (subject == null || autos == null) {
            throw new RuntimeException("The subject or auto credentials cannot be null when updating a subject with credentials");
        }
        try {
            for (IAutoCredentials autoCred : autos) {
                autoCred.updateSubject(subject, credentials);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ClientAuthUtils.insertWorkerTokens(subject, credentials);
    }

    public static ITransportPlugin getTransportPlugin(ThriftConnectionType type, Map<String, Object> topoConf, Configuration login_conf) {
        try {
            String transport_plugin_klassName = type.getTransportPlugin(topoConf);
            ITransportPlugin transportPlugin = (ITransportPlugin)ReflectionUtils.newInstance(transport_plugin_klassName);
            transportPlugin.prepare(type, topoConf, login_conf);
            return transportPlugin;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String makeDigestPayload(Configuration login_config, String config_section) {
        String username = null;
        String password = null;
        try {
            SortedMap<String, ?> results = ClientAuthUtils.pullConfig(login_config, config_section);
            username = (String)results.get(USERNAME);
            password = (String)results.get(PASSWORD);
        }
        catch (Exception e) {
            LOG.error("Failed to pull username/password out of jaas conf", (Throwable)e);
        }
        if (username == null || password == null) {
            return null;
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-512");
            byte[] output = digest.digest((username + ":" + password).getBytes());
            return Hex.encodeHexString((byte[])output);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("Cant run SHA-512 digest. Algorithm not available.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static byte[] serializeKerberosTicket(KerberosTicket tgt) throws Exception {
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bao);
        out.writeObject(tgt);
        out.flush();
        out.close();
        return bao.toByteArray();
    }

    public static KerberosTicket deserializeKerberosTicket(byte[] tgtBytes) {
        KerberosTicket ret;
        try {
            ByteArrayInputStream bin = new ByteArrayInputStream(tgtBytes);
            ObjectInputStream in = new ObjectInputStream(bin);
            ret = (KerberosTicket)in.readObject();
            in.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return ret;
    }

    public static KerberosTicket cloneKerberosTicket(KerberosTicket kerberosTicket) {
        if (kerberosTicket != null) {
            try {
                return ClientAuthUtils.deserializeKerberosTicket(ClientAuthUtils.serializeKerberosTicket(kerberosTicket));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to clone KerberosTicket TGT!!", e);
            }
        }
        return null;
    }
}

