/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.security.auth;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.storm.security.auth.IGroupMappingServiceProvider;
import org.apache.storm.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.RotatingMap;
import org.apache.storm.utils.ShellCommandRunner;
import org.apache.storm.utils.ShellCommandRunnerImpl;
import org.apache.storm.utils.ShellUtils;
import org.apache.storm.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellBasedGroupsMapping
implements IGroupMappingServiceProvider {
    public static final Logger LOG = LoggerFactory.getLogger(ShellBasedGroupsMapping.class);
    private final ShellCommandRunner shellCommandRunner;
    public RotatingMap<String, Set<String>> cachedGroups;
    private long timeoutMs;
    private volatile long lastRotationMs;

    public ShellBasedGroupsMapping() {
        this(new ShellCommandRunnerImpl());
    }

    @VisibleForTesting
    ShellBasedGroupsMapping(ShellCommandRunner shellCommandRunner) {
        this.shellCommandRunner = shellCommandRunner;
    }

    @Override
    public void prepare(Map<String, Object> topoConf) {
        this.timeoutMs = TimeUnit.SECONDS.toMillis(ObjectReader.getInt(topoConf.get("storm.group.mapping.service.cache.duration.secs")).intValue());
        this.lastRotationMs = Time.currentTimeMillis();
        this.cachedGroups = new RotatingMap(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getGroups(String user) throws IOException {
        ShellBasedGroupsMapping shellBasedGroupsMapping = this;
        synchronized (shellBasedGroupsMapping) {
            this.rotateIfNeeded();
            if (this.cachedGroups.containsKey(user)) {
                return this.cachedGroups.get(user);
            }
        }
        Set<String> groups = this.getUnixGroups(user);
        if (!groups.isEmpty()) {
            ShellBasedGroupsMapping shellBasedGroupsMapping2 = this;
            synchronized (shellBasedGroupsMapping2) {
                this.cachedGroups.put(user, groups);
            }
        }
        return groups;
    }

    private void rotateIfNeeded() {
        long nowMs = Time.currentTimeMillis();
        if (nowMs >= this.lastRotationMs + this.timeoutMs) {
            int rotationsToDo = (int)((nowMs - this.lastRotationMs) / this.timeoutMs);
            for (int i = 0; i < rotationsToDo; ++i) {
                this.cachedGroups.rotate();
            }
            this.lastRotationMs = nowMs;
        }
    }

    private Set<String> getUnixGroups(String user) throws IOException {
        String result2;
        try {
            result2 = this.shellCommandRunner.execCommand(ShellUtils.getGroupsForUserCommand(user));
        }
        catch (ShellUtils.ExitCodeException e) {
            LOG.debug("Unable to get groups for user " + user + ". ShellUtils command failed with exit code " + e.getExitCode());
            return new HashSet<String>();
        }
        HashSet<String> groups = new HashSet<String>();
        for (String group : result2.split(this.shellCommandRunner.getTokenSeparatorRegex())) {
            groups.add(group);
        }
        return groups;
    }
}

