/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.security.auth;

import java.util.Map;
import javax.security.auth.login.Configuration;
import org.apache.storm.security.auth.ClientAuthUtils;
import org.apache.storm.security.auth.ITransportPlugin;
import org.apache.storm.security.auth.TBackoffConnect;
import org.apache.storm.security.auth.ThriftConnectionType;
import org.apache.storm.thrift.protocol.TBinaryProtocol;
import org.apache.storm.thrift.protocol.TProtocol;
import org.apache.storm.thrift.transport.TSocket;
import org.apache.storm.thrift.transport.TTransport;
import org.apache.storm.utils.ObjectReader;

public class ThriftClient
implements AutoCloseable {
    protected TProtocol _protocol;
    protected boolean _retryForever = false;
    private TTransport _transport;
    private String _host;
    private Integer _port;
    private Integer _timeout;
    private Map _conf;
    private ThriftConnectionType _type;
    private String _asUser;

    public ThriftClient(Map<String, Object> topoConf, ThriftConnectionType type, String host) {
        this(topoConf, type, host, null, null, null);
    }

    public ThriftClient(Map<String, Object> topoConf, ThriftConnectionType type, String host, Integer port, Integer timeout) {
        this(topoConf, type, host, port, timeout, null);
    }

    public ThriftClient(Map<String, Object> topoConf, ThriftConnectionType type, String host, Integer port, Integer timeout, String asUser) {
        if (host == null) {
            throw new IllegalArgumentException("host is not set");
        }
        if (port == null) {
            port = type.getPort(topoConf);
        }
        if (timeout == null) {
            timeout = type.getSocketTimeOut(topoConf);
        }
        if (port <= 0 && !type.isFake()) {
            throw new IllegalArgumentException("invalid port: " + port);
        }
        this._host = host;
        this._port = port;
        this._timeout = timeout;
        this._conf = topoConf;
        this._type = type;
        this._asUser = asUser;
        if (!type.isFake()) {
            this.reconnect();
        }
    }

    public synchronized TTransport transport() {
        return this._transport;
    }

    public synchronized void reconnect() {
        this.close();
        TSocket socket = null;
        try {
            socket = new TSocket(this._host, this._port.intValue());
            if (this._timeout != null) {
                socket.setTimeout(this._timeout.intValue());
            }
            Configuration login_conf = ClientAuthUtils.getConfiguration(this._conf);
            ITransportPlugin transportPlugin = ClientAuthUtils.getTransportPlugin(this._type, this._conf, login_conf);
            TBackoffConnect connectionRetry = new TBackoffConnect(ObjectReader.getInt(this._conf.get("storm.nimbus.retry.times")), ObjectReader.getInt(this._conf.get("storm.nimbus.retry.interval.millis")), ObjectReader.getInt(this._conf.get("storm.nimbus.retry.intervalceiling.millis")), this._retryForever);
            this._transport = connectionRetry.doConnectWithRetry(transportPlugin, (TTransport)socket, this._host, this._asUser);
        }
        catch (Exception ex) {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new RuntimeException(ex);
        }
        this._protocol = null;
        if (this._transport != null) {
            this._protocol = new TBinaryProtocol(this._transport);
        }
    }

    @Override
    public synchronized void close() {
        if (this._transport != null) {
            this._transport.close();
            this._transport = null;
            this._protocol = null;
        }
    }
}

