/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.security.auth.kerberos;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import org.apache.storm.security.auth.ReqContext;
import org.apache.storm.security.auth.sasl.SaslTransportPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerCallbackHandler
implements CallbackHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ServerCallbackHandler.class);
    private final boolean impersonationAllowed;

    public ServerCallbackHandler(Configuration configuration, boolean impersonationAllowed) throws IOException {
        this.impersonationAllowed = impersonationAllowed;
        if (configuration == null) {
            return;
        }
        AppConfigurationEntry[] configurationEntries = configuration.getAppConfigurationEntry("StormServer");
        if (configurationEntries == null) {
            String errorMessage = "Could not find a 'StormServer' entry in this configuration: Server cannot start.";
            LOG.error(errorMessage);
            throw new IOException(errorMessage);
        }
    }

    @Override
    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        NameCallback nc = null;
        PasswordCallback pc = null;
        AuthorizeCallback ac = null;
        for (Callback callback : callbacks) {
            if (callback instanceof AuthorizeCallback) {
                ac = (AuthorizeCallback)callback;
                continue;
            }
            if (callback instanceof NameCallback) {
                nc = (NameCallback)callback;
                continue;
            }
            if (callback instanceof PasswordCallback) {
                pc = (PasswordCallback)callback;
                continue;
            }
            if (callback instanceof RealmCallback) continue;
            throw new UnsupportedCallbackException(callback, "Unrecognized SASL Callback");
        }
        String userName = "UNKNOWN";
        if (nc != null) {
            LOG.debug("handleNameCallback");
            userName = nc.getDefaultName();
            nc.setName(nc.getDefaultName());
        }
        if (pc != null) {
            LOG.error("No password found for user: {}, validate klist matches jaas conf", (Object)userName);
        }
        if (ac != null) {
            String authenticationID = ac.getAuthenticationID();
            LOG.debug("Successfully authenticated client: authenticationID={}  authorizationID= {}", (Object)authenticationID, (Object)ac.getAuthorizationID());
            if (ac.getAuthorizationID() == null) {
                ac.setAuthorizedID(authenticationID);
            }
            if (!ac.getAuthenticationID().equals(ac.getAuthorizationID())) {
                if (!this.impersonationAllowed) {
                    throw new IllegalArgumentException(ac.getAuthenticationID() + " attempting to impersonate " + ac.getAuthorizationID() + ".  This is not allowed by this server.");
                }
                ReqContext.context().setRealPrincipal(new SaslTransportPlugin.User(ac.getAuthenticationID()));
            } else {
                ReqContext.context().setRealPrincipal(null);
            }
            ac.setAuthorized(true);
        }
    }
}

