/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.serialization;

import com.esotericsoftware.kryo.io.Input;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.storm.serialization.ITupleDeserializer;
import org.apache.storm.serialization.KryoValuesDeserializer;
import org.apache.storm.serialization.SerializationFactory;
import org.apache.storm.task.GeneralTopologyContext;
import org.apache.storm.tuple.MessageId;
import org.apache.storm.tuple.TupleImpl;

public class KryoTupleDeserializer
implements ITupleDeserializer {
    GeneralTopologyContext _context;
    KryoValuesDeserializer _kryo;
    SerializationFactory.IdDictionary _ids;
    Input _kryoInput;

    public KryoTupleDeserializer(Map<String, Object> conf, GeneralTopologyContext context) {
        this._kryo = new KryoValuesDeserializer(conf);
        this._context = context;
        this._ids = new SerializationFactory.IdDictionary(context.getRawTopology());
        this._kryoInput = new Input(1);
    }

    @Override
    public TupleImpl deserialize(byte[] ser) {
        try {
            this._kryoInput.setBuffer(ser);
            int taskId = this._kryoInput.readInt(true);
            int streamId = this._kryoInput.readInt(true);
            String componentName = this._context.getComponentId(taskId);
            String streamName = this._ids.getStreamName(componentName, streamId);
            MessageId id = MessageId.deserialize(this._kryoInput);
            List<Object> values = this._kryo.deserializeFrom(this._kryoInput);
            return new TupleImpl(this._context, values, componentName, taskId, streamName, id);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

