/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.serialization;

import com.esotericsoftware.kryo.io.Output;
import java.io.IOException;
import java.util.Map;
import org.apache.storm.serialization.ITupleSerializer;
import org.apache.storm.serialization.KryoValuesSerializer;
import org.apache.storm.serialization.SerializationFactory;
import org.apache.storm.task.GeneralTopologyContext;
import org.apache.storm.tuple.Tuple;

public class KryoTupleSerializer
implements ITupleSerializer {
    KryoValuesSerializer _kryo;
    SerializationFactory.IdDictionary _ids;
    Output _kryoOut;

    public KryoTupleSerializer(Map<String, Object> conf, GeneralTopologyContext context) {
        this._kryo = new KryoValuesSerializer(conf);
        this._kryoOut = new Output(2000, 2000000000);
        this._ids = new SerializationFactory.IdDictionary(context.getRawTopology());
    }

    @Override
    public byte[] serialize(Tuple tuple) {
        try {
            this._kryoOut.clear();
            this._kryoOut.writeInt(tuple.getSourceTask(), true);
            this._kryoOut.writeInt(this._ids.getStreamId(tuple.getSourceComponent(), tuple.getSourceStreamId()), true);
            tuple.getMessageId().serialize(this._kryoOut);
            this._kryo.serializeInto(tuple.getValues(), this._kryoOut);
            return this._kryoOut.toBytes();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

