/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.serialization;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Output;
import java.util.List;
import java.util.Map;
import org.apache.storm.serialization.SerializationFactory;
import org.apache.storm.utils.ListDelegate;

public class KryoValuesSerializer {
    Kryo _kryo;
    ListDelegate _delegate;
    Output _kryoOut;

    public KryoValuesSerializer(Map<String, Object> conf) {
        this._kryo = SerializationFactory.getKryo(conf);
        this._delegate = new ListDelegate();
        this._kryoOut = new Output(2000, 2000000000);
    }

    public void serializeInto(List<Object> values, Output out) {
        this._delegate.setDelegate(values);
        this._kryo.writeObject(out, (Object)this._delegate);
    }

    public byte[] serialize(List<Object> values) {
        this._kryoOut.clear();
        this.serializeInto(values, this._kryoOut);
        return this._kryoOut.toBytes();
    }

    public byte[] serializeObject(Object obj) {
        this._kryoOut.clear();
        this._kryo.writeClassAndObject(this._kryoOut, obj);
        return this._kryoOut.toBytes();
    }
}

