/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.state;

import java.util.Optional;
import org.apache.storm.state.DefaultStateSerializer;
import org.apache.storm.state.Serializer;
import org.apache.storm.state.StateEncoder;

public class DefaultStateEncoder<K, V>
implements StateEncoder<K, V, byte[], byte[]> {
    public static final Serializer<Optional<byte[]>> internalValueSerializer = new DefaultStateSerializer<Optional<byte[]>>();
    public static final byte[] TOMBSTONE = internalValueSerializer.serialize(Optional.empty());
    private final Serializer<K> keySerializer;
    private final Serializer<V> valueSerializer;

    public DefaultStateEncoder(Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
    }

    public Serializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    public Serializer<V> getValueSerializer() {
        return this.valueSerializer;
    }

    @Override
    public byte[] encodeKey(K key) {
        return this.keySerializer.serialize(key);
    }

    @Override
    public byte[] encodeValue(V value) {
        return internalValueSerializer.serialize(Optional.of(this.valueSerializer.serialize(value)));
    }

    @Override
    public K decodeKey(byte[] encodedKey) {
        return this.keySerializer.deserialize(encodedKey);
    }

    @Override
    public V decodeValue(byte[] encodedValue) {
        Optional<byte[]> internalValue = internalValueSerializer.deserialize(encodedValue);
        if (internalValue.isPresent()) {
            return this.valueSerializer.deserialize(internalValue.get());
        }
        return null;
    }

    @Override
    public byte[] getTombstoneValue() {
        return TOMBSTONE;
    }
}

