/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.stats;

import com.codahale.metrics.Counter;
import java.util.ArrayList;
import org.apache.storm.generated.BoltStats;
import org.apache.storm.generated.ExecutorSpecificStats;
import org.apache.storm.generated.ExecutorStats;
import org.apache.storm.metric.internal.MultiCountStatAndMetric;
import org.apache.storm.metric.internal.MultiLatencyStatAndMetric;
import org.apache.storm.shade.com.google.common.collect.Lists;
import org.apache.storm.stats.ClientStatsUtil;
import org.apache.storm.stats.CommonStats;

public class BoltExecutorStats
extends CommonStats {
    MultiCountStatAndMetric executedStats;
    MultiLatencyStatAndMetric processLatencyStats;
    MultiLatencyStatAndMetric executeLatencyStats;

    public BoltExecutorStats(int rate, int numStatBuckets) {
        super(rate, numStatBuckets);
        this.executedStats = new MultiCountStatAndMetric(numStatBuckets);
        this.processLatencyStats = new MultiLatencyStatAndMetric(numStatBuckets);
        this.executeLatencyStats = new MultiLatencyStatAndMetric(numStatBuckets);
    }

    public MultiCountStatAndMetric getExecuted() {
        return this.executedStats;
    }

    public MultiLatencyStatAndMetric getProcessLatencies() {
        return this.processLatencyStats;
    }

    public MultiLatencyStatAndMetric getExecuteLatencies() {
        return this.executeLatencyStats;
    }

    @Override
    public void cleanupStats() {
        this.executedStats.close();
        this.processLatencyStats.close();
        this.executeLatencyStats.close();
        super.cleanupStats();
    }

    public void boltExecuteTuple(String component, String stream, long latencyMs) {
        ArrayList key = Lists.newArrayList((Object[])new String[]{component, stream});
        this.getExecuted().incBy(key, this.rate);
        this.getExecuteLatencies().record(key, latencyMs);
    }

    public void boltAckedTuple(String component, String stream, long latencyMs, Counter ackedCounter) {
        ArrayList key = Lists.newArrayList((Object[])new String[]{component, stream});
        this.getAcked().incBy(key, this.rate);
        ackedCounter.inc((long)this.rate);
        this.getProcessLatencies().record(key, latencyMs);
    }

    public void boltFailedTuple(String component, String stream, long latencyMs, Counter failedCounter) {
        ArrayList key = Lists.newArrayList((Object[])new String[]{component, stream});
        this.getFailed().incBy(key, this.rate);
        failedCounter.inc((long)this.rate);
    }

    @Override
    public ExecutorStats renderStats() {
        ExecutorStats ret = new ExecutorStats();
        ret.set_emitted(this.valueStat(this.getEmitted()));
        ret.set_transferred(this.valueStat(this.getTransferred()));
        ret.set_rate(this.rate);
        BoltStats boltStats = new BoltStats(ClientStatsUtil.windowSetConverter(this.valueStat(this.getAcked()), ClientStatsUtil.TO_GSID, ClientStatsUtil.IDENTITY), ClientStatsUtil.windowSetConverter(this.valueStat(this.getFailed()), ClientStatsUtil.TO_GSID, ClientStatsUtil.IDENTITY), ClientStatsUtil.windowSetConverter(this.valueStat(this.processLatencyStats), ClientStatsUtil.TO_GSID, ClientStatsUtil.IDENTITY), ClientStatsUtil.windowSetConverter(this.valueStat(this.executedStats), ClientStatsUtil.TO_GSID, ClientStatsUtil.IDENTITY), ClientStatsUtil.windowSetConverter(this.valueStat(this.executeLatencyStats), ClientStatsUtil.TO_GSID, ClientStatsUtil.IDENTITY));
        ret.set_specific(ExecutorSpecificStats.bolt(boltStats));
        return ret;
    }
}

