/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.task;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.storm.generated.NodeInfo;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.task.GeneralTopologyContext;
import org.apache.storm.tuple.Fields;

public class WorkerTopologyContext
extends GeneralTopologyContext {
    public static final String SHARED_EXECUTOR = "executor";
    Map<String, Object> _userResources;
    Map<String, Object> _defaultResources;
    private Integer _workerPort;
    private List<Integer> _workerTasks;
    private String _codeDir;
    private String _pidDir;
    private AtomicReference<Map<Integer, NodeInfo>> taskToNodePort;
    private String assignmentId;

    public WorkerTopologyContext(StormTopology topology, Map<String, Object> topoConf, Map<Integer, String> taskToComponent, Map<String, List<Integer>> componentToSortedTasks, Map<String, Map<String, Fields>> componentToStreamToFields, String stormId, String codeDir, String pidDir, Integer workerPort, List<Integer> workerTasks, Map<String, Object> defaultResources, Map<String, Object> userResources, AtomicReference<Map<Integer, NodeInfo>> taskToNodePort, String assignmentId) {
        super(topology, topoConf, taskToComponent, componentToSortedTasks, componentToStreamToFields, stormId);
        this._codeDir = codeDir;
        this._defaultResources = defaultResources;
        this._userResources = userResources;
        try {
            this._pidDir = pidDir != null ? new File(pidDir).getCanonicalPath() : null;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not get canonical path for " + this._pidDir, e);
        }
        this._workerPort = workerPort;
        this._workerTasks = workerTasks;
        this.taskToNodePort = taskToNodePort;
        this.assignmentId = assignmentId;
    }

    public WorkerTopologyContext(StormTopology topology, Map<String, Object> topoConf, Map<Integer, String> taskToComponent, Map<String, List<Integer>> componentToSortedTasks, Map<String, Map<String, Fields>> componentToStreamToFields, String stormId, String codeDir, String pidDir, Integer workerPort, List<Integer> workerTasks, Map<String, Object> defaultResources, Map<String, Object> userResources) {
        this(topology, topoConf, taskToComponent, componentToSortedTasks, componentToStreamToFields, stormId, codeDir, pidDir, workerPort, workerTasks, defaultResources, userResources, null, null);
    }

    public List<Integer> getThisWorkerTasks() {
        return this._workerTasks;
    }

    public Integer getThisWorkerPort() {
        return this._workerPort;
    }

    public String getThisWorkerHost() {
        return this.assignmentId;
    }

    public AtomicReference<Map<Integer, NodeInfo>> getTaskToNodePort() {
        return this.taskToNodePort;
    }

    public String getCodeDir() {
        return this._codeDir;
    }

    public String getPIDDir() {
        return this._pidDir;
    }

    public Object getResource(String name) {
        return this._userResources.get(name);
    }

    public ExecutorService getSharedExecutor() {
        return (ExecutorService)this._defaultResources.get(SHARED_EXECUTOR);
    }
}

