/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.testing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.testing.FixedTuple;
import org.apache.storm.topology.IRichBolt;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.tuple.Tuple;

public class TupleCaptureBolt
implements IRichBolt {
    public static final transient Map<String, Map<String, List<FixedTuple>>> emitted_tuples = new HashMap<String, Map<String, List<FixedTuple>>>();
    private String _name = UUID.randomUUID().toString();
    private OutputCollector _collector;

    public TupleCaptureBolt() {
        emitted_tuples.put(this._name, new HashMap());
    }

    @Override
    public void prepare(Map<String, Object> topoConf, TopologyContext context, OutputCollector collector) {
        this._collector = collector;
    }

    @Override
    public void execute(Tuple input) {
        String component = input.getSourceComponent();
        Map<String, List<FixedTuple>> captured = emitted_tuples.get(this._name);
        if (!captured.containsKey(component)) {
            captured.put(component, new ArrayList());
        }
        captured.get(component).add(new FixedTuple(input.getSourceStreamId(), input.getValues()));
        this._collector.ack(input);
    }

    public Map<String, List<FixedTuple>> getResults() {
        return emitted_tuples.get(this._name);
    }

    @Override
    public void cleanup() {
    }

    public Map<String, List<FixedTuple>> getAndRemoveResults() {
        return emitted_tuples.remove(this._name);
    }

    public Map<String, List<FixedTuple>> getAndClearResults() {
        HashMap<String, List<FixedTuple>> ret = new HashMap<String, List<FixedTuple>>(emitted_tuples.get(this._name));
        emitted_tuples.get(this._name).clear();
        return ret;
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer declarer) {
    }

    @Override
    public Map<String, Object> getComponentConfiguration() {
        return null;
    }
}

