/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.topology;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.storm.Config;
import org.apache.storm.StormSubmitter;
import org.apache.storm.shade.org.apache.commons.lang.StringUtils;
import org.apache.storm.shade.org.yaml.snakeyaml.Yaml;
import org.apache.storm.shade.org.yaml.snakeyaml.constructor.BaseConstructor;
import org.apache.storm.shade.org.yaml.snakeyaml.constructor.SafeConstructor;
import org.apache.storm.topology.TopologyBuilder;
import org.apache.storm.utils.Utils;

public abstract class ConfigurableTopology {
    protected Config conf = new Config();

    public static void start(ConfigurableTopology topology, String[] args) {
        String[] remainingArgs = topology.parse(args);
        try {
            topology.run(remainingArgs);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Config loadConf(String resource, Config conf) throws FileNotFoundException {
        Object confNode;
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor());
        Map ret = (HashMap)yaml.load((Reader)new InputStreamReader((InputStream)new FileInputStream(resource), Charset.defaultCharset()));
        if (ret == null) {
            ret = new HashMap();
        } else if (ret.size() == 1 && (confNode = ret.get("config")) != null && confNode instanceof Map) {
            ret = (Map)confNode;
        }
        conf.putAll(ret);
        return conf;
    }

    protected Config getConf() {
        return this.conf;
    }

    protected abstract int run(String[] var1) throws Exception;

    protected int submit(Config conf, TopologyBuilder builder) {
        String name = Utils.get(conf, "topology.name", null);
        if (StringUtils.isBlank((String)name)) {
            throw new RuntimeException("No value found for topology.name");
        }
        return this.submit(name, conf, builder);
    }

    protected int submit(String name, Config conf, TopologyBuilder builder) {
        try {
            StormSubmitter.submitTopology(name, conf, builder.createTopology());
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        return 0;
    }

    private String[] parse(String[] args) {
        ArrayList newArgs = new ArrayList();
        Collections.addAll(newArgs, args);
        Iterator iter = newArgs.iterator();
        while (iter.hasNext()) {
            String param = (String)iter.next();
            if (!param.equals("-conf")) continue;
            if (!iter.hasNext()) {
                throw new RuntimeException("Conf file not specified");
            }
            iter.remove();
            String resource = (String)iter.next();
            try {
                ConfigurableTopology.loadConf(resource, this.conf);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("File not found : " + resource);
            }
            iter.remove();
        }
        return newArgs.toArray(new String[newArgs.size()]);
    }
}

