/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.graph;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.storm.generated.SharedMemory;
import org.apache.storm.shade.org.jgrapht.DirectedGraph;
import org.apache.storm.trident.planner.Node;
import org.apache.storm.trident.util.IndexedEdge;
import org.apache.storm.trident.util.TridentUtils;

public class Group {
    public final Set<Node> nodes = new HashSet<Node>();
    private final DirectedGraph<Node, IndexedEdge> graph;
    private final String id = UUID.randomUUID().toString();

    public Group(DirectedGraph graph, List<Node> nodes) {
        this.graph = graph;
        this.nodes.addAll(nodes);
    }

    public Group(DirectedGraph graph, Node n) {
        this(graph, Arrays.asList(n));
    }

    public Group(Group g1, Group g2) {
        this.graph = g1.graph;
        this.nodes.addAll(g1.nodes);
        this.nodes.addAll(g2.nodes);
    }

    public Set<Node> outgoingNodes() {
        HashSet<Node> ret = new HashSet<Node>();
        for (Node n : this.nodes) {
            ret.addAll(TridentUtils.getChildren(this.graph, n));
        }
        return ret;
    }

    public Set<Node> incomingNodes() {
        HashSet<Node> ret = new HashSet<Node>();
        for (Node n : this.nodes) {
            ret.addAll(TridentUtils.getParents(this.graph, n));
        }
        return ret;
    }

    public Set<SharedMemory> getSharedMemory() {
        HashSet<SharedMemory> ret = new HashSet<SharedMemory>();
        for (Node n : this.nodes) {
            ret.addAll(n.getSharedMemory());
        }
        return ret;
    }

    public Map<String, Number> getResources(Map<String, Number> defaults) {
        if (defaults == null) {
            defaults = new HashMap<String, Number>();
        }
        HashMap<String, Number> resources = null;
        for (Node n : this.nodes) {
            if (resources == null) {
                resources = new HashMap<String, Number>(defaults);
                resources.putAll(n.getResources());
                continue;
            }
            HashMap<String, Number> node_res = new HashMap<String, Number>(defaults);
            node_res.putAll(n.getResources());
            if (!node_res.keySet().equals(resources.keySet())) {
                HashSet diffset;
                StringBuilder ops = new StringBuilder();
                for (Node nod : this.nodes) {
                    HashSet<String> resource_keys = new HashSet<String>(defaults.keySet());
                    resource_keys.addAll(nod.getResources().keySet());
                    ops.append("\t[ " + nod.shortString() + ", Resources Set: " + resource_keys + " ]\n");
                }
                if (node_res.keySet().containsAll(resources.keySet())) {
                    diffset = new HashSet(node_res.keySet());
                    diffset.removeAll(resources.keySet());
                    throw new RuntimeException("Found an operation with resources set which are not set in other operations in the group:\n\t[ " + n.shortString() + " ]: " + diffset + "\nEither set these resources in all other operations in the group, add a default setting, or remove the setting from this operation.\nThe group at fault:\n" + ops);
                }
                if (resources.keySet().containsAll(node_res.keySet())) {
                    diffset = new HashSet(resources.keySet());
                    diffset.removeAll(node_res.keySet());
                    throw new RuntimeException("Found an operation with resources unset which are set in other operations in the group:\n\t[ " + n.shortString() + " ]: " + diffset + "\nEither set these resources in all other operations in the group, add a default setting, or remove the setting from all other operations.\nThe group at fault:\n" + ops);
                }
            }
            for (Map.Entry kv : node_res.entrySet()) {
                String key = (String)kv.getKey();
                Number val = (Number)kv.getValue();
                Double newval = new Double(val.doubleValue() + ((Number)resources.get(key)).doubleValue());
                resources.put(key, newval);
            }
        }
        return resources;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return this.id.equals(((Group)o).id);
    }

    public String toString() {
        return this.nodes.toString();
    }
}

